<?php

namespace App\Console\Commands;

use App\Mail\EmailDiaSiguiente;
use App\Mail\FirmaVencidaMail;
use App\Models\SolicitudFirma;
use Carbon\Carbon;
use Illuminate\Console\Command;
use Illuminate\Support\Facades\Mail;

class FirmaVencidas extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'day:next';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Envia un email al usuario el dia siguiente que ha caducado su firma.';

    /**
     * Execute the console command.
     *
     * @return int
     */
    public function handle()
    {
        $solicitudes=SolicitudFirma::with('estado','entidad.contacto')->whereHas('estado',function($q){
            $q->where('fecha_vencimiento',Carbon::now()->subDays(1)->format('Y-m-d'));
        })->get();
        echo $solicitudes;
        foreach($solicitudes as $solicitud){
            Mail::to($solicitud->eMail)->send(new EmailDiaSiguiente($solicitud));
            $this->info('Email enviado correctamente');
        }
    }
}
