<?php

namespace App\Console;

use Illuminate\Console\Scheduling\Schedule;
use Illuminate\Foundation\Console\Kernel as ConsoleKernel;

class Kernel extends ConsoleKernel
{
    /**
     * Define the application's command schedule.
     *
     * @param  \Illuminate\Console\Scheduling\Schedule  $schedule
     * @return void
     */


    protected $commands=[
        \App\Console\Commands\FirmaVencidas::class,
        \App\Console\Commands\FirmaSieteDiasVencen::class,
        \App\Console\Commands\FirmaQuinceDiasVencen::class,
    ];

    protected function schedule(Schedule $schedule)
    {
        // $schedule->command('day:mail')->dailyAt('09:00');
        $schedule->command('day:email_quince')->everyMinute();
        $schedule->command('day:next')->everyMinute();
        $schedule->command('day:email_siete')->everyMinute();

    }

    /**
     * Register the commands for the application.
     *
     * @return void
     */
    protected function commands()
    {
        
        $this->load(__DIR__.'/Commands');

        require base_path('routes/console.php');
    }
}
