<?php

namespace App\Http\Controllers;

use App\Repositories\AccesoRepository;
use Exception;
use Illuminate\Auth\Access\AuthorizationException;
use Illuminate\Http\Request;

class AccesoController extends Controller
{
    private AccesoRepository $acceso;
    public function __construct(AccesoRepository $acceso) 
    {
        $this->acceso = $acceso;
        $this->middleware('auth:api');
    }

    public function listarAccesos(Request $request){
        try {
            // $this->authorize('listar-accesos');
            $request->merge([
                'page' => $request->input('page', 0) + 1
            ]);
            return ($this->acceso->getAllAccesos($request)->count()>0)?
            response()->json([
                'status'=>200,
                'message'=>'Lista de Accesos de todos los usuarios.',
                'data'=>$this->acceso->getAllAccesos($request)
            ],200):
            response()->json([
                'status'=>200,
                'message'=>'No hay registro de Accesos.',
                'data'=>null
            ],200);
        } catch(AuthorizationException $ae){
            return response()->json([
                'status'=>$ae->getCode(),
                'message'=>'No tiene permisos.',
                'data'=>$ae->getMessage()
            ],401) ;
        } catch (Exception $th) {
            return response()->json([
                'status'=>$th->getCode(),
                'message'=>'Ocurrio un error.',
                'data'=>$th->getMessage()
            ],400) ;
        }
        
    }

    public function listarAccesosEntidad(Request $request){
        try {
            // $this->authorize('listar-accesos-entidad');
            $request->merge([
                'page' => $request->input('page', 0) + 1
            ]);
            return ($this->acceso->getAllAccesosEntidad($request)->count()>0)?
            response()->json([
                'status'=>200,
                'message'=>'Lista de Accesos de todos los usuarios de la entidad.',
                'data'=>$this->acceso->getAllAccesosEntidad($request)
            ],200):
            response()->json([
                'status'=>200,
                'message'=>'No hay registro de Accesos.',
                'data'=>null
            ],200);
        } catch(AuthorizationException $ae){
            return response()->json([
                'status'=>$ae->getCode(),
                'message'=>'No tiene permisos.',
                'data'=>$ae->getMessage()
            ],401) ;
        } catch (Exception $th) {
            return response()->json([
                'status'=>$th->getCode(),
                'message'=>'Ocurrio un error.',
                'data'=>$th->getMessage()
            ],400) ;
        }
    }

    public function listarAccesosUsuario(Request $request,$idUsuario){
        try {
            // $this->authorize('listar-accesos-usuario');
            $request->merge([
                'page' => $request->input('page', 0) + 1
            ]);
            return ($this->acceso->getAccesosByIdUsuario($idUsuario,$request)->count()>0)?
            response()->json([
                'status'=>200,
                'message'=>'Lista de Accesos del usuario.',
                'data'=>$this->acceso->getAccesosByIdUsuario($idUsuario,$request)
            ],200):
            response()->json([
                'status'=>200,
                'message'=>'No hay registro de Accesos.',
                'data'=>null
            ],200);
        } catch(AuthorizationException $ae){
            return response()->json([
                'status'=>$ae->getCode(),
                'message'=>'No tiene permisos.',
                'data'=>$ae->getMessage()
            ],401) ;
        } catch (Exception $th) {
            return response()->json([
                'status'=>$th->getCode(),
                'message'=>'Ocurrio un error.',
                'data'=>$th->getMessage()
            ],400) ;
        }
        
    }

    public function listarAccesosUsuarioEntidad(Request $request,$idUsuario){
        try {
            // $this->authorize('listar-accesos-usuario-entidad');
            $request->merge([
                'page' => $request->input('page', 0) + 1
            ]);
            return ($this->acceso->getAccesosIdUsuarioEntidad($idUsuario,$request)->count()>0)?
            response()->json([
                'status'=>200,
                'message'=>'Lista de Accesos del usuario de entidad.',
                'data'=>$this->acceso->getAccesosIdUsuarioEntidad($idUsuario,$request)
            ],200):
            response()->json([
                'status'=>200,
                'message'=>'No hay registro de Accesos.',
                'data'=>null
            ],200);
        }catch (AuthorizationException $ae) {
            return response()->json([
                'status'=>$ae->getCode(),
                'message'=>'No tiene permisos.',
                'data'=>$ae->getMessage()
            ],401) ;
           
        } catch (Exception $th) {
            return response()->json([
                'status'=>$th->getCode(),
                'message'=>'Ocurrio un error.',
                'data'=>$th->getMessage()
            ],400) ;
        }

        
    }



}
