<?php

namespace App\Http\Controllers;

use App\Mail\EmailApkVersion;
use App\Models\AppVersion;
use Illuminate\Auth\Access\AuthorizationException;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;
use Exception;
use Illuminate\Support\Facades\Mail;

class AppVersionController extends Controller
{
    public function __construct()
    {
        // $this->middleware('auth:api');
    }
    public function crearAppVersion(Request $request)
    {
        try {
            $validator = Validator::make($request->all(), [
                'codigo_version' => 'required',
                'descripcion' => 'required',
                'fecha_creacion' => 'required',
                'responsable' => 'required',
                'url_apk' => 'required',
            ]);
            if ($validator->fails()) {
                return response()->json([
                    'status' => 422,
                    'message' => 'Error al validar los datos de entrada.',
                    'data' => $validator->errors()
                ], 422);
            } else {
                $app_version = AppVersion::create([
                    'codigo_version' => $request->codigo_version,
                    'descripcion' => $request->descripcion,
                    'fecha_creacion' => $request->fecha_creacion,
                    'responsable' => $request->responsable,
                    'estado' => false,
                    'url_apk' => $request->url_apk,
                ]);

                // $destinatario = $request->email;
                // Mail::to($destinatario)->send(new EmailSolicitudPrevia($solicitud_previa));

                return response()->json([
                    'status' => 201,
                    'message' => 'Version de App creada correctamente.',
                    'data' => $app_version
                ], 201);
            }
        } catch (\Throwable $th) {
            return response()->json([
                'status' => $th->getCode(),
                'message' => 'Ocurrio un error!.',
                'data' => $th->getMessage()
            ], 400);
        }
    }
    public function listarVersionesApp(Request $request)
    {
        try {
            $request->merge([
                'page' => $request->input('page', 0) + 1
            ]);
            $app_version = AppVersion::orderBy('updated_at', 'desc')
                ->paginate($request->query('per_page') ?? 10);
            return ($app_version != null) ?
                response()->json([
                    'status' => 200,
                    'message' => 'Versiones App listadas correctamente.',
                    'data' => $app_version
                ], 200) :
                response()->json([
                    'status' => 200,
                    'message' => 'No hay registro de Acciones.',
                    'data' => null
                ], 200);
        } catch (\Throwable $th) {
            return response()->json([
                'status' => $th->getCode(),
                'message' => 'Ocurrio un error!.',
                'data' => $th->getMessage()
            ], 400);
        }
    }
    public function activarAppVersion($id)
    {
        try {
            $version = AppVersion::find($id);
            if ($version != null) {
                // Verificar si hay otro registro con el estado establecido en 1
                $registroEstado1 = AppVersion::where('estado', 1)->first();
                if ($registroEstado1 != $version) {
                    if ($registroEstado1 != null) {
                        $registroEstado1->estado = 0;
                        $registroEstado1->save();
                    }
                }
                $version->estado = 1;
                $version->save();
                return response()->json([
                    'status' => 200,
                    'message' => 'Version de App actualizada correctamente.',
                    'data' => $version
                ], 200);
            } else {
                return response()->json([
                    'status' => 200,
                    'message' => 'No se encontro la version de App indicada.',
                    'data' => null
                ], 200);
            }
        } catch (AuthorizationException $th) {
            return response()->json([
                'status' => $th->getCode(),
                'message' => 'No autorizado!.',
                'data' => $th->getMessage()
            ], 401);
        } catch (Exception $e) {
            return response()->json([
                'status' => $e->getCode(),
                'message' => 'Ocurrio un error!.',
                'data' => $e->getMessage()
            ], 400);
        }
    }
    public function versionAppActiva(Request $request)
    {
        try {
            $validator = Validator::make($request->all(), [
                'token_api' => 'required|exists:api_coorporativos,token',
                'clave_api' => 'required|exists:api_coorporativos,clave_coorporativo',
            ]);
            if ($validator->fails()) {
                return response()->json([
                    'status' => 422,
                    'message' => 'Error al validar los datos de entrada.',
                    'data' => $validator->errors()
                ], 422);
            } else {
                $app_version = AppVersion::where('estado', 1)->first();
                return ($app_version != null) ?
                    response()->json([
                        'status' => 200,
                        'message' => 'Version Activa',
                        'data' => $app_version
                    ], 200) :
                    response()->json([
                        'status' => 200,
                        'message' => 'No hay una version activa.',
                        'data' => null
                    ], 200);
            }
        } catch (\Throwable $th) {
            return response()->json([
                'status' => $th->getCode(),
                'message' => 'Ocurrio un error!.',
                'data' => $th->getMessage()
            ], 400);
        }
    }
    public function enviarCorreo(Request $request)
    {
        try {
            $validator = Validator::make($request->all(), [
                'token_api' => 'required|exists:api_coorporativos,token',
                'clave_api' => 'required|exists:api_coorporativos,clave_coorporativo',
                'asunto' => 'required',
                'descripcion' => 'required',
                'email' => 'required'
            ]);
            if ($validator->fails()) {
                return response()->json([
                    'status' => 422,
                    'message' => 'Error al enviar correo.',
                    'data' => $validator->errors()
                ], 422);
            } else {

                $destinatario = $request->email;
                Mail::to($destinatario)->send(new EmailApkVersion($request));

                return response()->json([
                    'status' => 201,
                    'message' => 'Correo enviado.',
                    'data' => ('')
                ], 201);
            }
        } catch (\Throwable $th) {
            return response()->json([
                'status' => $th->getCode(),
                'message' => 'Ocurrio un error!.',
                'data' => $th->getMessage()
            ], 400);
        }
    }
}
