<?php

namespace App\Http\Controllers;

use App\Models\RegistroLote;
use App\Models\SolicitudLote;
use App\Repositories\FirmaEmpresarialRepository;
use App\Repositories\FirmaJuridicaRepository;
use App\Repositories\SolicitudFirmaRepository;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Validator;
use Illuminate\Validation\Rules\Enum;
use App\Enum\VigenciaFirmaEnum;
use App\Repositories\AccionRepository;
use App\Repositories\EstadoSolicitudRepository;
use App\Repositories\FirmaRepresentanteLegalRepository;
use Carbon\Carbon;
use Illuminate\Auth\Access\AuthorizationException;

class CargaMasivaController extends Controller
{
    private $solicitud_firma;
    private $empresarial;
    private $juridica;
    private $representante;
    private $estado;
    private $accion;
    public function __construct(SolicitudFirmaRepository $solicitud_firma, FirmaEmpresarialRepository $empresarial, FirmaJuridicaRepository $juridica, FirmaRepresentanteLegalRepository $representante, EstadoSolicitudRepository $estado, AccionRepository $accion)
    {
        $this->middleware('auth:api');
        $this->solicitud_firma = $solicitud_firma;
        $this->empresarial = $empresarial;
        $this->juridica = $juridica;
        $this->representante = $representante;
        $this->estado = $estado;
        $this->accion = $accion;
    }

    public function cargar(Request $request)
    {
        try {
            DB::beginTransaction();
            $errores = [];
            $ids_solicitudes = [];
            $solicitudes = $request->solicitudes;
            foreach ($solicitudes as $solicitud => $value) {
    
                if ($solicitud == 'natural') {
                    foreach ($value as $key => $value2) {
                        try {
                            $validator = Validator::make($value2, [
                                'numerodocumento' => 'required',
                                'nombres' => 'required|string',
                                'apellido1' => 'required|string',
                                'apellido2' => 'required|string',
                                'tipodocumento' => 'required|in:CEDULA,PASAPORTE',
                                'tipo_solicitud' => 'required|in:PERSONA NATURAL,MIEMBRO DE EMPRESA,REPRESENTANTE LEGAL,PERSONA JURIDICA',
                                'coddactilar' => 'required',
                                'ruc_personal' => 'nullable',
                                'sexo' => 'required|string|in:HOMBRE,MUJER',
                                'contenedor' => 'required|numeric|in:1,2,3',
                                'fecha_nacimiento' => 'required|date',
                                'nacionalidad' => 'required|string',
                                'telfCelular' => 'required|string',
                                'telfFijo' => 'nullable|string',
                                'eMail' => 'required|email',
                                'telfCelular2' => 'nullable|string',
                                'provincia' => 'required|string',
                                'ciudad' => 'required|string',
                                'direccion' => 'required|string',
                                'vigenciafirma' => [new Enum(VigenciaFirmaEnum::class)],
                                'entidad_solicitante' => 'uuid|exists:entidades,id',
                                'usuario_solicita' => 'uuid|exists:usuarios,id',
                                'fila' => 'required|numeric',
                            ]);
                            if ($validator->fails()) {
                                $errores[] = $validator->errors()->add('fila', 'Error en la fila ' . $value2['fila'] . ' en la pagina de Persona Natural');
                            } else {
                                $firma = $this->solicitud_firma->create($value2);
                                $this->estado->create([
                                    'solicitud_id' => $firma->id,
                                    'tipo_solicitud' => 'PERSONA NATURAL',
                                    'estado' => 'OBSERVACIONES',
                                    'observacion' => 'Solicitud Cargada Masiva',
                                    'uid_proveedor' => 'TEST ***',
                                    'creado_por' => auth()->user()->id,
                                    'fecha_registro' => Carbon::now()
    
                                ]);
                                $this->accion->create([
                                    'solicitud_id' => $firma->id,
                                    'nombre_accion' => 'Creo Soliciud de Firma',
                                    'descripcion'=>'Se creo nueva Soliciud de Firma por Carga Masiva',
                                ]);
                                $ids_solicitudes[] = $firma->id;
                            }
                        } catch (\Exception $th) {
                            $errores[] = $th->getMessage();
                        }
                    }
                }
                if ($solicitud == 'juridica') {
                    foreach ($value as $key => $value2) {
                        try {
                            $validator = Validator::make($value2, [
                                'numerodocumento' => 'required',
                                'nombres' => 'required|string',
                                'apellido1' => 'required|string',
                                'apellido2' => 'required|string',
                                'tipodocumento' => 'required|in:CEDULA,PASAPORTE',
                                'tipo_solicitud' => 'required|in:PERSONA NATURAL,MIEMBRO DE EMPRESA,REPRESENTANTE LEGAL,PERSONA JURIDICA',
                                'coddactilar' => 'required',
                                'ruc_personal' => 'nullable',
                                'sexo' => 'required|string|in:HOMBRE,MUJER',
                                'contenedor' => 'required|numeric|in:1,2,3',
                                'fecha_nacimiento' => 'required|date',
                                'nacionalidad' => 'required|string',
                                'telfCelular' => 'required|string',
                                'telfFijo' => 'nullable|string',
                                'eMail' => 'required|email',
                                'telfCelular2' => 'nullable|string',
                                'provincia' => 'required|string',
                                'ciudad' => 'required|string',
                                'direccion' => 'required|string',
                                'vigenciafirma' => [new Enum(VigenciaFirmaEnum::class)],
                                'entidad_solicitante' => 'uuid|exists:entidades,id',
                                'usuario_solicita' => 'uuid|exists:usuarios,id',
                                'fila' => 'required|numeric',
                            ]);
                            if ($validator->fails()) {
                                $errores[] = $validator->errors()->add('fila', 'Error en la fila ' . $value2['fila'] . ' en la pagina de Persona Juridica');
                            } else {
                                $solicitud_firma = $this->solicitud_firma->create($value2);
                                $value2['solicitud_id'] = $solicitud_firma->id;
                                $validator = Validator::make($value2, [
                                    'solicitud_id' => 'required|uuid|exists:solicitudes_firmas,id',
                                    'ruc_empresa' => 'required|string',
                                    'empresa' => 'required|string',
                                    'cargo' => 'required|string',
                                    'motivo' => 'required|string',
                                    'unidad' => 'required|string',
                                ]);
                                if ($validator->fails()) {
                                    $errores[] = $validator->errors()->add('fila', 'Error en la fila ' . $value2['fila'] . ' en la pagina de Persona Juridica');
                                } else {
                                    $firma = $this->juridica->create($value2);
                                    $this->estado->create([
                                        'solicitud_id' => $solicitud_firma->id,
                                        'tipo_solicitud' => 'PERSONA JURIDICA',
                                        'estado' => 'OBSERVACIONES',
                                        'observacion' => 'Solicitud Cargada Masiva',
                                        'uid_proveedor' => 'TEST ***',
                                        'creado_por' => auth()->user()->id,
                                        'fecha_registro' => Carbon::now()
    
                                    ]);
                                    $this->accion->create([
                                        'solicitud_id' => $solicitud_firma->id,
                                        'nombre_accion' => 'Creo Soliciud de Firma',
                                        'descripcion'=>'Se creo nueva Soliciud de Firma por Carga Masiva',
                                    ]);
                                    $ids_solicitudes[] = $firma->solicitud_id;
                                }
                            }
                        } catch (\Exception $th) {
                            $errores[] = $th->getMessage();
                        }
                    }
                }
                if ($solicitud == 'empresarial') {
                    foreach ($value as $key => $value2) {
                        try {
                            $validator = Validator::make($value2, [
                                'numerodocumento' => 'required',
                                'nombres' => 'required|string',
                                'apellido1' => 'required|string',
                                'apellido2' => 'required|string',
                                'tipodocumento' => 'required|in:CEDULA,PASAPORTE',
                                'tipo_solicitud' => 'required|in:PERSONA NATURAL,MIEMBRO DE EMPRESA,REPRESENTANTE LEGAL,PERSONA JURIDICA',
                                'coddactilar' => 'required',
                                'ruc_personal' => 'nullable',
                                'sexo' => 'required|string|in:HOMBRE,MUJER',
                                'contenedor' => 'required|numeric|in:1,2,3',
                                'fecha_nacimiento' => 'required|date',
                                'nacionalidad' => 'required|string',
                                'telfCelular' => 'required|string',
                                'telfFijo' => 'nullable|string',
                                'eMail' => 'required|email',
                                'telfCelular2' => 'nullable|string',
                                'provincia' => 'required|string',
                                'ciudad' => 'required|string',
                                'direccion' => 'required|string',
                                'vigenciafirma' => [new Enum(VigenciaFirmaEnum::class)],
                                'entidad_solicitante' => 'uuid|exists:entidades,id',
                                'usuario_solicita' => 'uuid|exists:usuarios,id',
                                'fila' => 'required|numeric',
                            ]);
                            if ($validator->fails()) {
                                $errores[] = $validator->errors()->add('fila', 'Error en la fila ' . $value2['fila'] . ' en la pagina de Persona Empresarial');
                            } else {
                                $solicitud_firma = $this->solicitud_firma->create($value2);
                                $value2['solicitud_id'] = $solicitud_firma->id;
                                $validator = Validator::make($value2, [
                                    'solicitud_id' => 'required|uuid|exists:solicitudes_firmas,id',
                                    'ruc_empresa' => 'required|string',
                                    'empresa' => 'required|string',
                                    'cargo' => 'required|string',
                                    'motivo' => 'required|string',
                                    'unidad' => 'required|string',
                                    'nombresRL' => 'required|string',
                                    'apellidosRL' => 'required|string',
                                    'numerodocumentoRL' => 'required|string',
                                    'tipodocumentoRL' => 'required|string',
                                ]);
                                if ($validator->fails()) {
                                    $errores[] = $validator->errors()->add('fila', 'Error en la fila ' . $value2['fila'] . ' en la pagina de Persona Empresarial');
                                } else {
                                    $firma = $this->empresarial->create($value2);
                                    $this->estado->create([
                                        'solicitud_id' => $solicitud_firma->id,
                                        'tipo_solicitud' => 'MIEMBRO DE EMPRESA',
                                        'estado' => 'OBSERVACIONES',
                                        'observacion' => 'Solicitud Cargada Masiva',
                                        'uid_proveedor' => 'TEST ***',
                                        'creado_por' => auth()->user()->id,
                                        'fecha_registro' => Carbon::now()
    
                                    ]);
                                    $this->accion->create([
                                        'solicitud_id' => $solicitud_firma->id,
                                        'nombre_accion' => 'Creo Soliciud de Firma',
                                        'descripcion'=>'Se creo nueva Soliciud de Firma por Carga Masiva',
                                    ]);
                                    $ids_solicitudes[] = $firma->solicitud_id;
                                }
                            }
                        } catch (\Exception $th) {
                            $errores[] = $th->getMessage();
                        }
                    }
                }
                if ($solicitud == 'representante_legal') {
                    foreach ($value as $key => $value2) {
                        try {
                            $validator = Validator::make($value2, [
                                'numerodocumento' => 'required',
                                'nombres' => 'required|string',
                                'apellido1' => 'required|string',
                                'apellido2' => 'required|string',
                                'tipodocumento' => 'required|in:CEDULA,PASAPORTE',
                                'tipo_solicitud' => 'required|in:PERSONA NATURAL,MIEMBRO DE EMPRESA,REPRESENTANTE LEGAL,PERSONA JURIDICA',
                                'coddactilar' => 'required',
                                'ruc_personal' => 'nullable',
                                'sexo' => 'required|string|in:HOMBRE,MUJER',
                                'contenedor' => 'required|numeric|in:1,2,3',
                                'fecha_nacimiento' => 'required|date',
                                'nacionalidad' => 'required|string',
                                'telfCelular' => 'required|string',
                                'telfFijo' => 'nullable|string',
                                'eMail' => 'required|email',
                                'telfCelular2' => 'nullable|string',
                                'provincia' => 'required|string',
                                'ciudad' => 'required|string',
                                'direccion' => 'required|string',
                                'vigenciafirma' => [new Enum(VigenciaFirmaEnum::class)],
                                'entidad_solicitante' => 'uuid|exists:entidades,id',
                                'usuario_solicita' => 'uuid|exists:usuarios,id',
                                'fila' => 'required|numeric',
                            ]);
                            if ($validator->fails()) {
                                $errores[] = $validator->errors()->add('fila', 'Error en la fila ' . $value2['fila'] . ' en la pagina de Representante Legal');
                            } else {
                                $solicitud_firma = $this->solicitud_firma->create($value2);
                                $value2['solicitud_id'] = $solicitud_firma->id;
                                $validator = Validator::make($value2, [
                                    'solicitud_id' => 'required|uuid|exists:solicitudes_firmas,id',
                                    'ruc_empresa' => 'required|string',
                                    'empresa' => 'required|string',
                                    'cargo' => 'required|string',
                                ]);
                                if ($validator->fails()) {
                                    $errores[] = $validator->errors()->add('fila', 'Error en la fila ' . $value2['fila'] . ' en la pagina de Representante Legal');
                                } else {
                                    $firma = $this->representante->create($value2);
                                    $this->estado->create([
                                        'solicitud_id' => $solicitud_firma->id,
                                        'tipo_solicitud' => 'REPRESENTANTE LEGAL',
                                        'estado' => 'OBSERVACIONES',
                                        'observacion' => 'Solicitud Cargada Masiva',
                                        'uid_proveedor' => 'TEST ***',
                                        'creado_por' => auth()->user()->id,
                                        'fecha_registro' => Carbon::now()
    
                                    ]);
                                    $this->accion->create([
                                        'solicitud_id' => $solicitud_firma->id,
                                        'nombre_accion' => 'Creo Soliciud de Firma',
                                        'descripcion'=>'Se creo nueva Soliciud de Firma por Carga Masiva',
                                    ]);
                                    $ids_solicitudes[] = $firma->solicitud_id;
                                }
                            }
                        } catch (\Exception $th) {
                            $errores[] = $th->getMessage();
                        }
                    }
                }
            }
            if (!empty($errores)) {
                DB::rollBack();
                return response()->json([
                    'status' => 400,
                    'message' => 'Error en la carga de solicitudes, revise los datos.',
                    'errors' => $errores,
                ], 400);
            } else {
                DB::commit();
                //Creo un registro lote
                $registro_lote = RegistroLote::create([
                    'usuario_registra' => auth()->user()->id,
                    'entidad_id' => auth()->user()->entidad_id,
                    'fecha_carga' => Carbon::now(),
                    'archivo_url' => $request->archivo_url,
                    'finalizado' => false,
                ]);
                //Creo una solicitud de lote
                
                foreach ($ids_solicitudes as $key => $value) {
                  
                    $solicitud_lote = SolicitudLote::create([
                        'lote_id' => $registro_lote->id,
                        'solicitud_id' => $value,
                        'estado'=>'PROCESADO'
                    ]);
                    
                }
                return response()->json([
                    'status' => 200,
                    'message' => 'Solicitudes cargadas correctamente.',
                    'data' => null,
                ], 200);
            }
        } catch (AuthorizationException $e) {
            return response()->json([
                'status' => 401,
                'message' => 'No tiene permisos!.',
                'data' => $e->getMessage(),
            ], 401);
        }

    }
}
