<?php

namespace App\Http\Controllers;

use App\Models\RegistroLote;
use App\Models\SolicitudLote;
use App\Repositories\FirmaEmpresarialRepository;
use App\Repositories\FirmaJuridicaRepository;
use App\Repositories\SolicitudFirmaPreviaRepository;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Validator;
use Illuminate\Validation\Rules\Enum;
use App\Enum\VigenciaFirmaEnum;
use App\Repositories\FirmaRepresentanteLegalRepository;
use Carbon\Carbon;
use Illuminate\Auth\Access\AuthorizationException;
use Illuminate\Support\Facades\Mail;
use App\Mail\EmailSolicitudPrevia;
use App\Models\TipoFirma;

class CargaMasivaPreviaController extends Controller
{
    private $solicitud_firma;
    private $empresarial;
    private $juridica;
    private $representante;
    private $estado;
    private $accion;
    public function __construct(SolicitudFirmaPreviaRepository $solicitud_firma, FirmaEmpresarialRepository $empresarial, FirmaJuridicaRepository $juridica, FirmaRepresentanteLegalRepository $representante)
    {
        $this->middleware('auth:api');
        $this->solicitud_firma = $solicitud_firma;
        $this->empresarial = $empresarial;
        $this->juridica = $juridica;
        $this->representante = $representante;
    }

    public function cargar(Request $request)
    {
        try {
            DB::beginTransaction();
            $errores = [];
            $ids_solicitudes = [];
            $solicitudes = $request->solicitudes;
            foreach ($solicitudes as $solicitud => $value) {

                if ($solicitud == 'natural') {
                    foreach ($value as $key => $value2) {
                        try {
                            $validator = Validator::make($value2, [
                                'email' => 'required|email',
                                'identificacion' => 'required',
                                'telefono' => 'required|string',
                                'contenedor' => 'required|numeric|in:1,2,3',
                                'requiere_facturacion' => 'required',
                                'numero_facturas' => 'required|numeric',
                                'requiere_firma' => 'required',
                                'vigenciafirma' => 'required|in:7 dias,1 año,2 años,3 años,4 años,5 años'
                            ]);
                            if ($validator->fails()) {
                                $errores[] = $validator->errors()->add('fila', 'Error en la fila ' . $value2['fila'] . ' en la pagina de Persona Natural');
                            } else {
                                $firma = $this->solicitud_firma->create($value2);
                                $ids_solicitudes[] = $firma->id;
                                $destinatario = $firma->email;
                                Mail::to($destinatario)->send(new EmailSolicitudPrevia($firma));
                            }
                        } catch (\Exception $th) {
                            $errores[] = $th->getMessage();
                        }
                    }
                }
            }
            if (!empty($errores)) {
                DB::rollBack();
                return response()->json([
                    'status' => 400,
                    'message' => 'Error en la carga de solicitudes, revise los datos.',
                    'errors' => $errores,
                ], 400);
            } else {
                DB::commit();
                // //Creo un registro lote
                // $registro_lote = RegistroLote::create([
                //     'usuario_registra' => auth()->user()->id,
                //     'entidad_id' => auth()->user()->entidad_id,
                //     'fecha_carga' => Carbon::now(),
                //     'archivo_url' => $request->archivo_url,
                //     'finalizado' => false,
                // ]);
                // //Creo una solicitud de lote

                // foreach ($ids_solicitudes as $key => $value) {

                //     $solicitud_lote = SolicitudLote::create([
                //         'lote_id' => $registro_lote->id,
                //         'solicitud_id' => $value,
                //         'estado' => 'PROCESADO'
                //     ]);

                // }
                return response()->json([
                    'status' => 200,
                    'message' => 'Solicitudes cargadas correctamente.',
                    'data' => null,
                ], 200);
            }
        } catch (AuthorizationException $e) {
            return response()->json([
                'status' => 401,
                'message' => 'No tiene permisos!.',
                'data' => $e->getMessage(),
            ], 401);
        }
    }

    public function crear(Request $request)
    {
        try {
            //PRODUCCION
            $url = "https://firmas.firmaecplus.com/formularioFirmas/";
            //DESARROLLO
            //$baseUrl = "http://localhost:3000/formularioFirmas/";
            $errores = [];
            try {
                $validator = Validator::make($request->all(), [
                    'cantidad' => 'required|integer|min:1',
                    'tipo_persona' => 'required',
                    'tipo_firma_id' => 'required|exists:tipos_firmas,id',
                    'precio' => 'required'
                ]);
                if ($validator->fails()) {
                    return response()->json([
                        'status' => 422,
                        'message' => 'Error al validar los datos de entrada.',
                        'data' => $validator->errors()
                    ], 422);
                } else {
                    $tipo_firma = TipoFirma::find($request->tipo_firma_id);
                    $infor = $tipo_firma->tipo_firma;

                    if ($tipo_firma) {
                        switch ($infor) {
                            case 'ARCHIVO':
                                $contenedor = 1;
                                break;

                            case 'TOKEN':
                                $contenedor = 2;
                                break;

                            case 'NUBE':
                                $contenedor = 3;
                                break;

                            default:
                                $contenedor = 0;
                                break;
                        }
                    } else {
                        // Maneja el caso en el que no se encuentre ningún registro con el precio_firma_id proporcionado
                    }
                    // dd($tipo_firma->tiempo_validez);
                    $solicitudesCreadas = [];
                    for ($i = 0; $i < $request->cantidad; $i++) {
                        $firma = $this->solicitud_firma->create([
                            'contenedor' => $contenedor,
                            'requiere_facturacion' => false,
                            'numero_facturas' => 0,
                            'requiere_firma' => true,
                            'vigenciafirma' => $tipo_firma->tiempo_validez,
                            'tipo_persona' => $request->tipo_persona,
                            'precio' => $request->precio,
                            'tipo_solicitud' => "NUEVA QR"
                        ]);
                        $solicitudesCreadas[] = [
                            'id' => $firma->id,
                            'url' => $baseUrl . $firma->id,  // Construye la URL con el ID de la solicitud
                        ];
                    }
                    return response()->json([
                        'status' => 201,
                        'message' => 'Solicitudes previas con qr generadas correctamente.',
                        'data' => $solicitudesCreadas
                    ], 201);
                }
            } catch (\Exception $th) {
                $errores[] = $th->getMessage();
            }
            if (!empty($errores)) {
                return response()->json([
                    'status' => 400,
                    'message' => 'Error en la carga de solicitudes, revise los datos.',
                    'errors' => $errores,
                ], 400);
            } else {
                return response()->json([
                    'status' => 200,
                    'message' => 'Solicitudes cargadas correctamente.',
                    'data' => null,
                ], 200);
            }
        } catch (AuthorizationException $e) {
            return response()->json([
                'status' => 401,
                'message' => 'No tiene permisos!.',
                'data' => $e->getMessage(),
            ], 401);
        }
    }
}
