<?php

namespace App\Http\Controllers;

use App\Models\CodigoPais;
use Illuminate\Http\Request;

class CodigoPaisesController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
    }
    
    public function listarCodigoPaises(){
        try {
            $lst_cod=CodigoPais::all();
            return response()->json([
                'status'=>200,
                'message'=>'Listado de  Codigo de Paises',
                'data'=>$lst_cod
            ],200);
        } catch (\Throwable $th) {
            return response()->json([
                'status'=>$th->getCode(),
                'message'=>'Ocurrio un error!.',
                'data'=>$th->getMessage()
            ],400);
        }
    }
}
