<?php

namespace App\Http\Controllers;

use App\Models\SolicitudPrevia;
use App\Repositories\SolicitudFirmaPreviaRepository;
use Illuminate\Http\Request;
use Illuminate\Support\Str;
use GuzzleHttp\Client;
use Illuminate\Support\Facades\Http;

class CronCambiosEstadoSolicitudController extends Controller
{

    public function __construct(SolicitudFirmaPreviaRepository $solicitud_firma_previa)
    {
        $this->solicitud_firma_previa = $solicitud_firma_previa;
        //$this->middleware('auth:api');
    }

    public function cambioEstado($estado)
    {
        $baseUrl = env('UANATACA_UID_API_ENDPOINT');
        $apikey = env('UANATACA_API_KEY');
        $uid = env('UANATACA_UID');

        try {
            $estado = (int)$estado;
            if (is_int($estado) && $estado > 0 && $estado < 13) {
                $solicitudes = $this->solicitud_firma_previa->getSolicitudPorEstado($estado);
                if (count($solicitudes) > 0) {
                    foreach ($solicitudes as $itemS) {
                        if ($itemS->identificacion && $itemS->tipo_persona) {
                            $response = Http::post($baseUrl . '/v4/consultarEstado/', [
                                //'Content-Type' => 'application/json',
                                'apikey' => $apikey,
                                'uid' => $uid,
                                'numerodocumento' => $itemS->identificacion,
                                'tipo_solicitud' => $itemS->tipo_persona
                            ]);
                            $responseDecode = json_decode($response->body());
                            if (isset($responseDecode->data) && isset($responseDecode->data->solicitudes) && count($responseDecode->data->solicitudes) > 0) {
                                foreach ($responseDecode->data->solicitudes as $itemRS) {
                                    if ($itemS->uanataca_id == $itemRS->uid) {
                                        $response=$this->actualizarEstadoDB( $itemRS->estado,$itemS->id);
                                    }

                                }
                            }
                        }

                    }
                }

                return 200;
            } else {
                return response()->json([
                    'status' => 422,
                    'message' => 'El estado ingresado es incorrecto.',
                    'data' => 'Estado Formato incorrecto.'
                ], 422);
            }

        } catch (Exception $e) {
            return response()->json([
                'status' => $e->getCode(),
                'message' => 'Ocurrio un error.',
                'data' => $e->getMessage()
            ], 400);
        }
    }

    public function actualizarEstadoDB($estado,$idSolicitudPrevia)
    {
        $nuevoEstado=0;
        switch ($estado) {
            case 'ASIGNADO':
                $nuevoEstado=3;
                break;
            case 'EN VALIDACION':
                $nuevoEstado=4;
                break;
            case 'RECHAZADO':
                $nuevoEstado=5;
                break;
            case 'ELIMINADO':
                $nuevoEstado=6;
                break;
            case 'APROBADO':
                $nuevoEstado=7;
                break;
            case 'RECHAZADO Y ENVIADO':
                $nuevoEstado=12;
                break;
        }
        if($nuevoEstado>0){
            try {
                $response=SolicitudPrevia::where('id','=',$idSolicitudPrevia)->update([
                    'estado'=>$nuevoEstado
                ]);
                return 200;
            }catch (Exception $e){
                return response()->json([
                    'status' => $e->getCode(),
                    'message' => 'Ocurrio un error.',
                    'data' => $e->getMessage()
                ], 400);
            }
        }
    }

}
