<?php

namespace App\Http\Controllers;

use App\Models\DiagnosticoDispositivo;
use Illuminate\Auth\Access\AuthorizationException;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;

class DiagnosticoDispositivoAuthController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth:api');
    }

    public function listarDiagnosticoDispositivos(Request $request)
    {
        try {
            $this->authorize('registrar-dispositivo');
            $request->merge([
                'page' => $request->input('page', 0) + 1
            ]);
            $listDiagnosticos = DiagnosticoDispositivo::with('dispositivo')
                ->orderBy('updated_at', 'desc')
                ->paginate($request->query('per_page') ?? 10);
            return ($listDiagnosticos != null) ?
                response()->json([
                    'status' => 200,
                    'message' => 'Disgnosticos en dispositivos listados correctamente.',
                    'data' => $listDiagnosticos
                ], 200) :
                response()->json([
                    'status' => 200,
                    'message' => 'No hay registro de Disgnosticos en dispositivos.',
                    'data' => null
                ], 200);
        } catch (\Throwable $th) {
            return response()->json([
                'status' => $th->getCode(),
                'message' => 'Ocurrio un error!.',
                'data' => $th->getMessage()
            ], 400);
        }
    }

    public function listarDiagnosticosDispositivo(Request $request, $dispositivoId)
    {
        try {
            $this->authorize('registrar-dispositivo');
            $request->merge([
                'page' => $request->input('page', 0) + 1
            ]);

            $listDiagnosticos = DiagnosticoDispositivo::with('dispositivo')
                ->where('dispositivo_id', $dispositivoId)
                ->orderBy('updated_at', 'desc')
                ->paginate($request->query('per_page') ?? 10);

            return ($listDiagnosticos->count() > 0) ?
                response()->json([
                    'status' => 200,
                    'message' => 'Diagnosticos del dispositivo listados correctamente.',
                    'data' => $listDiagnosticos
                ], 200) :
                response()->json([
                    'status' => 200,
                    'message' => 'No hay registro de Diagnosticos en el dispositivo.',
                    'data' => null
                ], 200);
        } catch (\Throwable $th) {
            return response()->json([
                'status' => $th->getCode(),
                'message' => 'Ocurrió un error.',
                'data' => $th->getMessage()
            ], 400);
        }
    }

    public function ultimoDiagnosticoDispositivo($dispositivoId)
    {
        try {
            $this->authorize('registrar-dispositivo');

            $ultimoDiagnostico = DiagnosticoDispositivo::with('dispositivo')
                ->where('dispositivo_id', $dispositivoId)
                ->first();

            if ($ultimoDiagnostico) {
                return response()->json([
                    'status' => 200,
                    'message' => 'Último diagnóstico del dispositivo obtenido correctamente.',
                    'data' => $ultimoDiagnostico
                ], 200);
            } else {
                return response()->json([
                    'status' => 200,
                    'message' => 'No hay registro de diagnóstico en el dispositivo.',
                    'data' => null
                ], 200);
            }
        } catch (\Throwable $th) {
            return response()->json([
                'status' => $th->getCode(),
                'message' => 'Ocurrió un error.',
                'data' => $th->getMessage()
            ], 400);
        }
    }
}
