<?php

namespace App\Http\Controllers;

use App\Models\DiagnosticoDispositivo;
use Illuminate\Auth\Access\AuthorizationException;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;

class DiagnosticoDispositivoController extends Controller
{
    public function __construct()
    {
        // $this->middleware('auth:api');
    }
    public function crearDiagnosticoDispositivo(Request $request)
    {
        try {
            $validator = Validator::make($request->all(), [
                'token_api' => 'required|exists:api_coorporativos,token',
                'clave_api' => 'required|exists:api_coorporativos,clave_coorporativo',
                'dispositivo_id' => 'required|exists:dispositivo,id',
                'observaciones_diagnostico' => 'required',
                'estado_diagnostico' => 'required',
                'version_apk_instalada' => 'required',
                'ip_publica' => 'required',
                'estado_camara' => 'required',
                'nivel_bateria' => 'required',
                'estado_impresora' => 'required',
                'velocidad_subida' => 'required',
                'velocidad_bajada' => 'required',
                'tipo_conexion' => 'required',
            ]);
            if ($validator->fails()) {
                return response()->json([
                    'status' => 422,
                    'message' => $validator->errors(),
                ], 422);
            } else {
                $dispositivo = DiagnosticoDispositivo::create([
                    'dispositivo_id' => $request->dispositivo_id,
                    'observaciones_diagnostico' => $request->observaciones_diagnostico,
                    'estado_diagnostico' => $request->estado_diagnostico,
                    'version_apk_instalada' => $request->version_apk_instalada,
                    'ip_publica' => $request->ip_publica,
                    'estado_camara' => $request->estado_camara,
                    'nivel_bateria' => $request->nivel_bateria,
                    'estado_impresora' => $request->estado_impresora,
                    'velocidad_subida' => $request->velocidad_subida,
                    'velocidad_bajada' => $request->velocidad_bajada,
                    'tipo_conexion' => $request->tipo_conexion,
                ]);
                return response()->json([
                    'status' => 201,
                    'message' => 'Diagnostico de dispositivo creado correctamente',
                    'data' => $dispositivo,
                ], 201);
            }
        } catch (AuthorizationException $th) {
            return response()->json([
                'status' => $th->getCode(),
                'message' => 'No tiene permisos para crear diagnostico del dipositivos',
                'data' => $th->getMessage(),
            ], 401);
        } catch (\Exception $e) {
            return response()->json([
                'status' => $e->getCode(),
                'message' => 'Error al crear el diagnostico del dispositivo',
                'data' => $e->getMessage(),
            ], 400);
        }
    }
}
