<?php

namespace App\Http\Controllers;

use App\Models\ApiCoorporativo;
use App\Models\Dispositivo;
use App\Models\EntidadComercial;
use Illuminate\Auth\Access\AuthorizationException;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;

class DispositivoNoAuthController extends Controller
{
    public function __construct()
    {
        // $this->middleware('auth:api');
    }
    public function actualizarDispositivoApi(Request $request, $id)
    {
        try {
            $validator = Validator::make($request->all(), [
                'token_api' => 'required|exists:api_coorporativos,token',
                'clave_api' => 'required|exists:api_coorporativos,clave_coorporativo',
            ]);
            if ($validator->fails()) {
                return response()->json([
                    'status' => 422,
                    'message' => 'Error al actualizar el dispositivo.',
                    'data' => $validator->errors()
                ], 422);
            } else {

                $dispositivo = Dispositivo::findOrFail($id);

                $dispositivo->fill($request->all());
                if ($request->has('ubicacion')) {
                    $dispositivo->ubicacion = json_encode($request->ubicacion);
                }

                $dispositivo->save();

                return response()->json([
                    'status' => 200,
                    'message' => 'Dispositivo actualizado correctamente',
                    'data' => $dispositivo,
                ], 200);
            }
        } catch (AuthorizationException $th) {
            return response()->json([
                'status' => $th->getCode(),
                'message' => 'No tiene permisos para actualizar dispositivos',
                'data' => $th->getMessage(),
            ], 401);
        } catch (\Exception $e) {
            return response()->json([
                'status' => $e->getCode(),
                'message' => 'Error al actualizar el dispositivo',
                'data' => $e->getMessage(),
            ], 400);
        }
    }

    public function ultimaConexion(Request $request)
    {
        try {
            $validator = Validator::make($request->all(), [
                'token_api' => 'required|exists:api_coorporativos,token',
                'clave_api' => 'required|exists:api_coorporativos,clave_coorporativo',
                'fecha' => 'required'
            ]);
            if ($validator->fails()) {
                return response()->json([
                    'status' => 422,
                    'message' => 'Error al actualizar el dispositivo.',
                    'data' => $validator->errors()
                ], 422);
            } else {

                $apiCoorporativo = ApiCoorporativo::where('token', $request->input('token_api'))
                    ->where('clave_coorporativo', $request->input('clave_api'))
                    ->first();

                if ($apiCoorporativo) {
                    $entidad_id = $apiCoorporativo->entidad_id;

                    $dispositivo = Dispositivo::where('entidad_id', $entidad_id)->first();

                    if ($dispositivo) {
                        // Se encontró el dispositivo correspondiente.
                        $dispositivo_id = $dispositivo->id;

                        // Actualizar el campo ultima_conexion del dispositivo con el valor de fecha del request.
                        $dispositivo->update(['ultima_conexion' => $request->input('fecha')]);

                        return response()->json([
                            'status' => 200,
                            'message' => 'Dispositivo actualizado correctamente',
                            'data' => [
                                'entidad_id' => $entidad_id,
                                'dispositivo_id' => $dispositivo_id,
                                'ultima_conexion' => $request->input('fecha')
                            ],
                        ], 200);
                    } else {
                        // Manejo de error si no se encuentra el dispositivo correspondiente.
                        return response()->json([
                            'status' => 404,
                            'message' => 'No se encontró el dispositivo correspondiente al entidad_id proporcionado.',
                            'data' => null,
                        ], 404);
                    }
                } else {
                    return response()->json([
                        'status' => 404,
                        'message' => 'No se encontró el registro correspondiente con el token y clave_coorporativo proporcionados.',
                        'data' => null,
                    ], 404);
                }
            }
        } catch (AuthorizationException $th) {
            return response()->json([
                'status' => $th->getCode(),
                'message' => 'No tiene permisos para actualizar dispositivos',
                'data' => $th->getMessage(),
            ], 401);
        } catch (\Exception $e) {
            return response()->json([
                'status' => $e->getCode(),
                'message' => 'Error al actualizar el dispositivo',
                'data' => $e->getMessage(),
            ], 400);
        }
    }


    public function consultarDispositivo(Request $request)
    {
        try {
            $validator = Validator::make($request->all(), [
                'token_api' => 'required|exists:api_coorporativos,token',
                'clave_api' => 'required|exists:api_coorporativos,clave_coorporativo',
            ]);

            if ($validator->fails()) {
                return response()->json([
                    'status' => 422,
                    'message' => 'Error al buscar el dispositivo.',
                    'data' => $validator->errors()
                ], 422);
            } else {
                $apiCoorporativo = ApiCoorporativo::where('token', $request->input('token_api'))
                    ->where('clave_coorporativo', $request->input('clave_api'))
                    ->first();

                if ($apiCoorporativo) {
                    $entidadComercial = EntidadComercial::find($apiCoorporativo->entidad_id);

                    if ($entidadComercial) {
                        $dispositivo = Dispositivo::where('entidad_id', $entidadComercial->id)->first();

                        if ($dispositivo) {
                            return response()->json([
                                'status' => 200,
                                'message' => 'Dispositivo encontrado',
                                'data' => $dispositivo,
                            ], 200);
                        } else {
                            return response()->json([
                                'status' => 404,
                                'message' => 'No se encontró ningún dispositivo',
                            ], 404);
                        }
                    } else {
                        return response()->json([
                            'status' => 404,
                            'message' => 'No se encontró ninguna entidad comercial',
                        ], 404);
                    }
                } else {
                    return response()->json([
                        'status' => 404,
                        'message' => 'No se encontró ningún dispositivo',
                    ], 404);
                }
            }
        } catch (AuthorizationException $th) {
            return response()->json([
                'status' => $th->getCode(),
                'message' => 'No tiene permisos para consultar dispositivos',
                'data' => $th->getMessage(),
            ], 401);
        } catch (\Exception $e) {
            return response()->json([
                'status' => $e->getCode(),
                'message' => 'Error al consultar el dispositivo',
                'data' => $e->getMessage(),
            ], 400);
        }
    }

    public function hacerPing(Request $request)
    {
        $host = $request->input('host');

        // Ejecutar el comando de ping (Linux/MacOS):
        $pingResponse = shell_exec("ping $host");

        // Ejecutar el comando de ping (Windows):
        // $pingResponse = shell_exec("ping -n 4 $host");
        // dd($pingResponse);

        preg_match('/Media = (\d+)ms/', $pingResponse, $matches);
        $latency = isset($matches[1]) ? intval($matches[1]) : null;
        
        if ($latency) {
            return response()->json([
                'status' => 200,
                'message' => 'Ping realizado correctamente.',
                'data' => $latency,
            ], 200);
        } else {
            return response()->json([
                'status' => 400,
                'message' => 'Error al realizar el ping.',
                'data' => null,
            ], 400);
        }
    }
}
