<?php

namespace App\Http\Controllers;

use App\Models\Facturacion;
use App\Models\LogDispositivo;
use Illuminate\Auth\Access\AuthorizationException;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;
use GuzzleHttp\Client;
use GuzzleHttp\Exception\RequestException;

class FacturacionController extends Controller
{
    public function __construct()
    {
        // $this->middleware('auth:api');
    }
    public function crearFactura(Request $request)
    {
        try {
            $validator = Validator::make($request->all(), [
                'token_api' => 'required|exists:api_coorporativos,token',
                'clave_api' => 'required|exists:api_coorporativos,clave_coorporativo',
                'trama_factura' => 'required',
            ]);
            if ($validator->fails()) {
                return response()->json([
                    'status' => 422,
                    'message' => $validator->errors(),
                ], 422);
            } else {
                // Realizar la petición a la API
                $client = new Client();
                $url = 'https://api.comprobantes-electronicos.com/v1/Factura';
                $headers = [
                    'user' => '1793204865001',
                    'key' => 'a4b0ca1d-85fe-4bb8-bcfb-a3b450146b48',
                ];
                $trama_factura = $request->input('trama_factura');

                try {
                    $response = $client->post($url, [
                        'headers' => $headers,
                        'json' => $trama_factura,
                    ]);

                    $statusCode = $response->getStatusCode();
                    $responseData = json_decode($response->getBody(), true);

                    // Aquí puedes procesar la respuesta de la API como desees
                    if ($response->getStatusCode() === 200) {
                        // La petición fue exitosa, procesamos la respuesta y almacenamos la información en Facturacion
                        $responseData = json_decode($response->getBody(), true);
                        $cliente = $trama_factura['cliente'];
                        $pagos = $trama_factura['pagos'];
                        // Extraemos los datos relevantes de la trama_factura
                        $razonSocialCliente = $cliente['razonSocial']; // Asegúrate que la clave 'razonSocial' sea la correcta en la trama
                        $identificacionCliente = $cliente['identificacion']; // Asegúrate que la clave 'identificacion' sea la correcta en la trama
                        $totalPagos = $pagos[0]['total'];; // Asegúrate que la clave 'total' sea la correcta en la trama
                        $detalle = json_encode($trama_factura); // Convertimos la trama completa en JSON para guardarla en el campo 'detalle'

                        // Creamos una nueva instancia de Facturacion y la guardamos en la base de datos
                        $facturacion = Facturacion::create([
                            'cliente' => $razonSocialCliente,
                            'identificacion' => $identificacionCliente,
                            'total' => $totalPagos,
                            'detalle' => $detalle,
                            'estado' => $responseData['estado'],
                            'clave_acceso' => $responseData['claveAcceso'],
                            'mensaje' => $responseData['mensaje'],
                        ]);

                        // Si el campo 'numero_factura' es autoincrementable en la base de datos, se generará automáticamente el número de factura.
                        // En caso contrario, si necesitas definirlo manualmente, puedes asignarlo con el valor adecuado.

                        // Si deseas utilizar el ID de la nueva instancia como número de factura:
                    }

                    return response()->json([
                        'status' => $statusCode,
                        'message' => 'Petición a la API exitosa',
                        'data' => $responseData,
                    ], $statusCode);
                } catch (RequestException $e) {
                    $response = $e->getResponse();
                    $statusCode = $response->getStatusCode();
                    $responseData = json_decode($response->getBody(), true);

                    return response()->json([
                        'status' => $statusCode,
                        'message' => 'Error al realizar la petición a la API',
                        'data' => $responseData,
                    ], $statusCode);
                }
            }
        } catch (AuthorizationException $th) {
            return response()->json([
                'status' => $th->getCode(),
                'message' => 'No tiene permisos para crear Log del dipositivo',
                'data' => $th->getMessage(),
            ], 401);
        } catch (\Exception $e) {
            return response()->json([
                'status' => $e->getCode(),
                'message' => 'Error al crear el Log del dispositivo',
                'data' => $e->getMessage(),
            ], 400);
        }
    }
}
