<?php

namespace App\Http\Controllers;

use App\Models\InterfazEntidadComercial;
use Exception;
use Illuminate\Auth\Access\AuthorizationException;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;


class InterfazEntidadComercialController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth:api',['except' => ['buscarSlug']]);
       
    }
    public function crearIEC(Request $request){
        try {
            $validator=Validator::make($request->all(),[
                'entidad_id'=>'required|exists:entidades_comerciales,id',
                'url_logo'=>'required|string',
                'color_principal'=>'required|string',
                'color_secundario'=>'required|string',
                'color_gradient'=>'required|string',
                'slug'=>'required|string'
            ]);
            if ($validator->fails()) {
                return response()->json([
                    'status'=>422,
                    'message'=>'Error al validar los datos.',
                    'data'=>$validator->errors()
                ],422);
            } else {
               $iec=InterfazEntidadComercial::create($request->all());

               return response()->json([
                    'status'=>200,
                    'message'=>'Se creo correctamente la Interfaz de Entidad Comercial',
                    'data'=>$iec
                ],200);
            }
            
        } catch (\Throwable $th) {
            return response()->json([
                'status'=>$th->getCode(),
                'message'=>'Ha ocurrido un error!.',
                'data'=>$th->getMessage()
            ],400);
        }
    }
    public function listarIEC(Request $request){
        try {
            // $this->authorize('crear-usuario-administrador');
            $request->merge([
                'page' => $request->input('page', 0) + 1
            ]);
            $lst_iec=InterfazEntidadComercial::with('entidad')->paginate($request->query('per_page') ?? 10);
            if ($lst_iec!=null) {
                return response()->json([
                    'status'=>200,
                    'message'=>'Lista de Interfaces de Entidades Comerciales.',
                    'data'=>$lst_iec
                ]);
               } else {
                return response()->json([
                    'status'=>200,
                    'message'=>'No hay Interfaces de Entidades Comerciales.',
                    'data'=>null
                ]);
               }
            } 
            catch (\Throwable $th) {
                return response()->json([
                    'status'=>$th->getCode(),
                    'message'=>'Ocurrio un error!.',
                    'data'=>$th->getMessage()
                ],400);
            }
            
    }
    public function actualizarIEC(Request $request, $id){
        try {
            $iec=InterfazEntidadComercial::find($id);
            if($iec!=null){
                $iec->update($request->all());
                return response()->json([
                    'status'=>200,
                    'message'=>'Interfaz de Entidad Comercial actualizado correctamente.',
                    'data'=>$iec
                ]);
            }
            else{
                return response()->json([
                    'status'=>200,
                    'message'=>'No se encontro la Interfaz de Entidad Comercial indicada.',
                    'data'=>null
                ]);
            }
        } catch (\Throwable $th) {
            return response()->json([
                'status'=>$th->getCode(),
                'message'=>'Ocurrio un error!.',
                'data'=>$th->getMessage()
            ],400);
        }
    }
    public function verIEC($id){
        try {
            $iec=InterfazEntidadComercial::with('entidad')->
            whereHas('entidad',function($q) use ($id){
                $q->where('id',$id);
            })->first();

            if($iec!=null){
                return response()->json([
                    'status'=>200,
                    'message'=>'Datos de Interfaz de Entidad Comercial.',
                    'data'=>$iec
                ]);
            }
            else{
                return response()->json([
                    'status'=>200,
                    'message'=>'No se encontro datos de la Interfaz de Entidad Comercial indicada.',
                    'data'=>null
                ]);
            }
            
        } catch (\Throwable $th) {
            return response()->json([
                'status'=>$th->getCode(),
                'message'=>'Ocurrio un error!.',
                'data'=>$th->getMessage()
            ],400);
        }
    }
    public function buscarSlug(Request $request){
        try {
            $ier=InterfazEntidadComercial::where('slug',$request->slug)->first();
            return($ier!=null) ? 
            response()->json([
                'status'=>200,
                'message'=>'Interfaz de Entidad Comercial encontrado.',
                'data'=>$ier
            ],200) : 
            response()->json([
                'status'=>200,
                'message'=>'No se encontro la Interfaz de Entidad Comercial.',
                'data'=>null
            ],200);
        } catch (Exception $e) {
            return response()->json([
                'status'=>$e->getCode(),
                'message'=>'Ocurrio un error!.',
                'data'=>$e->getMessage()
            ],400);
        } catch(AuthorizationException $ae){
            return response()->json([
                'status'=>$ae->getCode(),
                'message'=>'No tiene permisos!.',
                'data'=>$ae->getMessage()
            ],401);
        }
    }

    public function eliminarIEC($id){
        try {
            $iec=InterfazEntidadComercial::find($id);
            if ($iec!=null) {
                $iec->update([
                    'estado'=>false
                ]);
                return response()->json([
                    'status'=>200,
                    'message'=>'Precio de Firma eliminado correctamente.',
                    'data'=>null
                ]);
            } else {
                return response()->json([
                    'status'=>200,
                    'message'=>'No se encontro el Precio de Firma indicado.',
                    'data'=>null
                ]);
            }
            
        } catch (\Throwable $th) {
            return response()->json([
                'status'=>$th->getCode(),
                'message'=>'Ocurrio un error!.',
                'data'=>$th->getMessage()
            ],400);
        }
    }

    public function cargarIEC(){
        try {
            $iec=InterfazEntidadComercial::with('entidad')->whereHas('entidad',function($q){
                $q->where('id',auth()->user()->entidad_id);
            })->first();
            if($iec!=null){
                return response()->json([
                    'status'=>200,
                    'message'=>'Datos de Interfaz de Entidad Comercial.',
                    'data'=>$iec
                ]);
            }
            else{
                return response()->json([
                    'status'=>200,
                    'message'=>'El usuario no tiene datos de Interfaz registradas.',
                    'data'=>null
                ]);
            }
        } catch (\Throwable $th) {
            return response()->json([
                'status'=>$th->getCode(),
                'message'=>'Ocurrio un error!.',
                'data'=>$th->getMessage()
            ],400);
        }
    }
    
}
