<?php

namespace App\Http\Controllers;

use App\Models\LogDispositivo;
use Illuminate\Auth\Access\AuthorizationException;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;

class LogDispositivoController extends Controller
{
    public function __construct()
    {
        // $this->middleware('auth:api');
    }
    public function crearlogDispositivo(Request $request)
    {
        try {
            $validator = Validator::make($request->all(), [
                'token_api' => 'required|exists:api_coorporativos,token',
                'clave_api' => 'required|exists:api_coorporativos,clave_coorporativo',
                'dispositivo_id' => 'required|exists:dispositivo,id',
                'descripcion' => 'required',
                'fecha_log' => 'required',
                'tipo_log' => 'required',
            ]);
            if ($validator->fails()) {
                return response()->json([
                    'status' => 422,
                    'message' => $validator->errors(),
                ], 422);
            } else {
                $dispositivo = LogDispositivo::create([
                    'dispositivo_id' => $request->dispositivo_id,
                    'descripcion' => $request->descripcion,
                    'fecha_log' => $request->fecha_log,
                    'tipo_log' => $request->tipo_log,
                ]);
                return response()->json([
                    'status' => 201,
                    'message' => 'Log de dispositivo creado correctamente',
                    'data' => $dispositivo,
                ], 201);
            }
        } catch (AuthorizationException $th) {
            return response()->json([
                'status' => $th->getCode(),
                'message' => 'No tiene permisos para crear Log del dipositivo',
                'data' => $th->getMessage(),
            ], 401);
        } catch (\Exception $e) {
            return response()->json([
                'status' => $e->getCode(),
                'message' => 'Error al crear el Log del dispositivo',
                'data' => $e->getMessage(),
            ], 400);
        }
    }
}
