<?php

namespace App\Http\Controllers;

use App\Models\PagoPinpad;
use Illuminate\Auth\Access\AuthorizationException;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;

class PagoPinpadController extends Controller
{
    public function __construct()
    {
        // $this->middleware('auth:api');
    }
    public function crearPagoPinpad(Request $request)
    {
        try {
            $validator = Validator::make($request->all(), [
                'entidad_id' => 'required|exists:entidades_comerciales,id',
                'valor_pagado' => 'required',
                'fecha_pago' => 'required',
                'usuario_registra' => 'required',
                'tipo_pago' => 'required',
                'comprobante_url' => 'required',
                'descripcion' => 'required',
                'validado' => 'required',
                'usuario_valida' => 'required',
                'solicitud_previa_id' => 'required|exists:solicitudes_previas,id',
                'CodigoRespuesta' => 'required',
                'RedAdquirente' => 'required',
                'CodigoRespuestaAut' => 'required',
                'Lote' => 'required',
                'Hora' => 'required',
                'Fecha' => 'required',
                'Autorizacion' => 'required',
                'TID' => 'required',
                'MID' => 'required',
                'NombreAdquirente' => 'required',
                'TarjetaHabiente' => 'required',
                'Referencia' => 'required'
            ]);
            if ($validator->fails()) {
                return response()->json([
                    'status' => 422,
                    'message' => $validator->errors(),
                ], 422);
            } else {
                $pago = PagoPinpad::create([
                    'entidad_id' => $request->entidad_id,
                    'valor_pagado' => $request->valor_pagado,
                    'fecha_pago' => $request->fecha_pago,
                    'usuario_registra' => $request->usuario_registra,
                    'tipo_pago' => $request->tipo_pago,
                    'comprobante_url' => $request->comprobante_url,
                    'descripcion' => $request->descripcion,
                    'validado' => $request->validado,
                    'usuario_valida' => $request->usuario_valida,
                    'solicitud_previa_id' => $request->solicitud_previa_id,
                    'CodigoRespuesta' => $request->CodigoRespuesta,
                    'RedAdquirente' => $request->RedAdquirente,
                    'CodigoRespuestaAut' => $request->CodigoRespuestaAut,
                    'Lote' => $request->Lote,
                    'Hora' => $request->Hora,
                    'Fecha' => $request->Fecha,
                    'Autorizacion' => $request->Autorizacion,
                    'TID' => $request->TID,
                    'MID' => $request->MID,
                    'NombreAdquirente' => $request->NombreAdquirente,
                    'TarjetaHabiente' => $request->TarjetaHabiente,
                    'Referencia' => $request->Referencia,
                ]);
                return response()->json([
                    'status' => 201,
                    'message' => 'Pago almacenado con éxito',
                    'data' => $pago,
                ], 201);
            }
        } catch (AuthorizationException $th) {
            return response()->json([
                'status' => $th->getCode(),
                'message' => 'No tiene permisos para almacenar pagos',
                'data' => $th->getMessage(),
            ], 401);
        } catch (\Exception $e) {
            return response()->json([
                'status' => $e->getCode(),
                'message' => 'Error al crear el pago',
                'data' => $e->getMessage(),
            ], 400);
        }
    }
}
