<?php

namespace App\Http\Controllers;

use App\Models\PrecioFirma;
use Exception;
use Illuminate\Auth\Access\AuthorizationException;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;

class PrecioFirmaController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth:api');
    }
    public function crearPrecioFirma(Request $request)
    {
        try {
            // $this->authorize('registrar-preciosFirmas');
            $validator = Validator::make($request->all(), [
                'entidad_id' => 'required|exists:entidades_comerciales,id',
                'precio' => 'required|numeric',
                'pvp' => 'required|numeric',
                'tipo_firma_id' => 'required|exists:tipos_firmas,id',
                'fecha_inicio' => 'required|date',
                'fecha_fin' => 'required|date',
                'disc_renovacion' => 'required',
                'disc_serv_publicos' => 'required'
            ]);
            if ($validator->fails()) {
                return response()->json([
                    'status' => 422,
                    'message' => 'Ocurrio un error al validar los datos.',
                    'data' => $validator->errors()
                ], 422);
            } else {
                $p_firma = PrecioFirma::create($request->all() + [
                    'usuario_registra' => auth()->id()
                ]);
                return response()->json([
                    'status' => 201,
                    'message' => 'Se creo correctamente el nuevo precio de firma.',
                    'data' => $p_firma
                ], 201);
            }
        } catch (Exception $th) {
            return response()->json([
                'status' => $th->getCode(),
                'message' => 'Ha ocurrido un error!.',
                'data' => $th->getMessage()
            ], 400);
        } catch (AuthorizationException $e) {
            return response()->json([
                'status' => $e->getCode(),
                'message' => 'No tiene permisos!.',
                'data' => $e->getMessage()
            ], 401);
        }
    }
    public function listarPreciosFirmas(Request $request)
    {
        try {
            $request->merge([
                'page' => $request->input('page', 0) + 1
            ]);
            $entidad = $request->input('entidad_id');
            $lst_precios = PrecioFirma::with('entidad', 'usuario_registra', 'tipo_firma')
                ->where('entidad_id', $entidad)
                ->orderBy('pvp', 'asc')
                ->paginate($request->query('per_page') ?? 10);
            if ($lst_precios != null) {
                return response()->json([
                    'status' => 200,
                    'message' => 'Lista de Precios de Firmas.',
                    'data' => $lst_precios
                ]);
            } else {
                return response()->json([
                    'status' => 200,
                    'message' => 'No hay Precios de Firmas registrados.',
                    'data' => null
                ]);
            }
        } catch (\Throwable $th) {
            return response()->json([
                'status' => $th->getCode(),
                'message' => 'Ocurrio un error!.',
                'data' => $th->getMessage()
            ], 400);
        }
    }
    public function actualizarPrecioFirma(Request $request, $id)
    {
        try {
            // $this->authorize('actualizar-preciosFirmas');
            $p_firma = PrecioFirma::find($id);
            if ($p_firma != null) {
                $p_firma->update($request->all());
                return response()->json([
                    'status' => 200,
                    'message' => 'Precio de Firma actualizado correctamente.',
                    'data' => $p_firma
                ]);
            } else {
                return response()->json([
                    'status' => 200,
                    'message' => 'No se encontro el Precio de Firma indicado.',
                    'data' => null
                ]);
            }
        } catch (Exception $th) {
            return response()->json([
                'status' => $th->getCode(),
                'message' => 'Ocurrio un error!.',
                'data' => $th->getMessage()
            ], 400);
        } catch (AuthorizationException $e) {
            return response()->json([
                'status' => $e->getCode(),
                'message' => 'No tiene permisos!.',
                'data' => $e->getMessage()
            ], 401);
        }
    }

    //No tiene permiso
    public function eliminarPrecioFirma($id)
    {
        try {
            $p_firma = PrecioFirma::find($id);
            if ($p_firma != null) {
                $p_firma->update([
                    'estado' => false
                ]);
                return response()->json([
                    'status' => 200,
                    'message' => 'Precio de Firma eliminado correctamente.',
                    'data' => null
                ]);
            } else {
                return response()->json([
                    'status' => 200,
                    'message' => 'No se encontro el Precio de Firma indicado.',
                    'data' => null
                ]);
            }
        } catch (\Throwable $th) {
            return response()->json([
                'status' => $th->getCode(),
                'message' => 'Ocurrio un error!.',
                'data' => $th->getMessage()
            ], 400);
        }
    }
    //No tiene permiso
    public function verPrecioFirma($id)
    {
        try {
            $p_firma = PrecioFirma::with('entidad', 'tipo_firma', 'usuario_registra')->where('estado', true)->where('id', $id)->first();
            if ($p_firma != null) {
                return response()->json([
                    'status' => 200,
                    'message' => 'Datos de Precio de Firma.',
                    'data' => $p_firma
                ]);
            } else {
                return response()->json([
                    'status' => 200,
                    'message' => 'No se encontro datos del Precio de Firma indicado.',
                    'data' => null
                ]);
            }
        } catch (\Throwable $th) {
            return response()->json([
                'status' => $th->getCode(),
                'message' => 'Ocurrio un error!.',
                'data' => $th->getMessage()
            ], 400);
        }
    }
    public function listarPreciosFirmasEntidad($id)
    {
        try {
            $lst_precios = PrecioFirma::with('entidad', 'usuario_registra', 'tipo_firma')
                ->whereHas('entidad', function ($query) use ($id) {
                    $query->where('id', $id);
                })
                ->where('estado', true)
                ->orderBy('pvp', 'asc')
                ->get();

            if ($lst_precios->count() > 0) {
                return response()->json([
                    'status' => 200,
                    'message' => 'Lista de Precios de Firmas.',
                    'data' => $lst_precios
                ]);
            } else {
                return response()->json([
                    'status' => 200,
                    'message' => 'No hay Precios de Firmas registrados.',
                    'data' => null
                ]);
            }
        } catch (\Throwable $th) {
            return response()->json([
                'status' => $th->getCode(),
                'message' => 'Ocurrio un error!.',
                'data' => $th->getMessage()
            ], 400);
        }
    }
    public function actualizarPVP(Request $request, $id)
    {
        try {
            // $this->authorize('actualizar-pvp-preciosFirmas');
            $precio = PrecioFirma::find($id);
            if ($precio == null) {
                return response()->json([
                    'status' => 200,
                    'message' => 'No se encontro el Precio de Firma indicado.',
                    'data' => null
                ]);
            } else {
                $precio->update([
                    'pvp' => $request->pvp
                ]);
                return response()->json([
                    'status' => 200,
                    'message' => 'PVP actualizado correctamente.',
                    'data' => null
                ]);
            }
        } catch (Exception $th) {
            return response()->json([
                'status' => $th->getCode(),
                'message' => 'Ocurrio un error!.',
                'data' => $th->getMessage()
            ], 400);
        } catch (AuthorizationException $e) {
            return response()->json([
                'status' => $e->getCode(),
                'message' => 'No tiene permisos!.',
                'data' => $e->getMessage()
            ], 401);
        }
    }
}
