<?php

namespace App\Http\Controllers;

use App\Models\Contacto;
use App\Models\EntidadComercial;
use App\Models\SolicitudesIniciales;
use App\Models\Usuario;
use App\Models\ValidarIdentificacion;
use Carbon\Carbon;
use Exception;
use Illuminate\Auth\Access\AuthorizationException;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Str;

class RedActivaController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth:api');
    }
    public function crearNuevaSolicitud(Request $request)
    {
        try {
            // $this->authorize('registrar-redActiva');
            $validator = Validator::make($request->all(), [
                'cedula' => 'required',
                'email' => 'required',
                'celular' => 'required',
                'entidad_id' => 'required',
            ]);

            if ($validator->fails()) {
                return response()->json([
                    'status' => 422,
                    'message' => 'Error al validar los datos de entrada.',
                    'data' => $validator->errors()
                ], 422);
            } else {
                $request->entidad_id=$this->decryptId('decrypt', $request->entidad_id);
                $entidad_comercial=EntidadComercial::find( $request->entidad_id);
                $validarIdentificacion=new ValidarIdentificacion();
                $validarCedula=$validarIdentificacion->validarCedula($request->cedula);

                if(!$validarCedula){
                    return response()->json([
                        'status' => 422,
                        'message' => 'Error al validar los datos de entrada.',
                        'data' => 'Cédula Inválida'
                    ], 422);
                }
                if($entidad_comercial){
                    $solicitudes_iniciales = SolicitudesIniciales::create([
                        'cedula' => $request->cedula,
                        'email' => $request->email,
                        'telefono' => $request->celular,
                        'entidad_id' => $entidad_comercial->id,
                        'estado' => 'NUEVO',
                    ]);

                }else{
                    return response()->json([
                        'status' => 422,
                        'message' => 'Error al validar los datos de entrada.',
                        'data' => 'No se encontro entidad comercial autorizada'
                    ], 422);
                }
                return response()->json([
                    'status' => 201,
                    'message' => 'Solicitud creada correctamente.',
                    'data' => $solicitudes_iniciales
                ], 201);
            }
        } catch (AuthorizationException $th) {
            return response()->json([
                'status'=>$th->getCode(),
                'message'=>'No autorizado!.',
                'data'=>$th->getMessage()
            ],401);
        } catch(Exception $e){
            return response()->json([
                'status'=>$e->getCode(),
                'message'=>'Ocurrio un error!.',
                'data'=>$e->getMessage()
            ],400);
        }
    }

}
