<?php

namespace App\Http\Controllers;

use App\Http\Requests\SolicitudFirmaRequest;
use App\Models\SolicitudFirma;
use App\Repositories\AccionRepository;
use App\Repositories\SolicitudFirmaRepository;
use Carbon\Carbon;
use App\Repositories\EstadoSolicitudRepository;
use Exception;
use Illuminate\Auth\Access\AuthorizationException;
use Illuminate\Http\Request;
use Illuminate\Support\Str;
use Maatwebsite\Excel\Facades\Excel;
use App\Exports\SolicitudesExport;


class SolicitudFirmaController extends Controller
{
    private $solicitud_firma;
    private $estado;
    private $accion;

    public function __construct(SolicitudFirmaRepository $solicitud_firma, EstadoSolicitudRepository $estado, AccionRepository $accion)
    {
        $this->solicitud_firma = $solicitud_firma;
        $this->estado = $estado;
        $this->accion = $accion;
        $this->middleware('auth:api');
    }

    public function listarSolicitudesFirma(Request $request)
    {
        try {
            // $this->authorize('listar-solicitudes');
            $request->merge([
                'page' => $request->input('page', 0) + 1
            ]);
            $lst_solicitudes = $this->solicitud_firma->getAll($request);
            return ($lst_solicitudes != null) ?
                response()->json([
                    'status' => 200,
                    'message' => 'Lista de Solicitudes de Firma.',
                    'data' => $lst_solicitudes
                ], 200) :
                response()->json([
                    'status' => 200,
                    'message' => 'No hay Solicitudes de Firma.',
                    'data' => $lst_solicitudes
                ], 200);
        } catch (AuthorizationException $ae) {
            return response()->json([
                'status' => $ae->getCode(),
                'message' => 'No tiene permisos!.',
                'data' => $ae->getMessage()
            ], 401);
        } catch (Exception $e) {
            return response()->json([
                'status' => $e->getCode(),
                'message' => 'Ocurrio un error.',
                'data' => $e->getMessage()
            ], 400);
        }
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function crearSolicitudFirma(SolicitudFirmaRequest $request)
    {
        try {
            // $this->authorize('registrar-solicitud');
            $solicitud_firma = $this->solicitud_firma->create($request->all());
            $this->accion->create([
                'solicitud_id' => $solicitud_firma->id,
                'nombre_accion' => 'Creo Soliciud de Firma',
                'descripcion' => 'Se creo nueva Soliciud de Firma',
            ]);
            $this->estado->create($request->all() + [
                'solicitud_id' => $solicitud_firma->id,
                'tipo_solicitud' => $solicitud_firma->tipo_solicitud,
                'estado' => 'NUEVO',
                'uid_proveedor' => 'TEST ***',
                'creado_por' => auth()->user()->id,
                'fecha_registro' => Carbon::now()
            ]);
            return response()->json([
                'status' => 201,
                'message' => 'Se creo correctamente la Solicitud Firma',
                'data' => $solicitud_firma->load('estado')
            ]);
        } catch (AuthorizationException $ae) {
            return response()->json([
                'status' => $ae->getCode(),
                'message' => 'No tiene permisos!',
                'data' => $ae->getMessage()
            ], 401);
        } catch (Exception $e) {
            return response()->json([
                'status' => $e->getCode(),
                'message' => 'Ocurrio un error!',
                'data' => $e->getMessage()
            ], 400);
        }
    }

    public function verSolicitudFirma($solicitudFirma_id)
    {
        try {
            if (Str::isUuid($solicitudFirma_id) == true) {
                $solicitud = $this->solicitud_firma->getById($solicitudFirma_id);
                return ($solicitud != null) ?
                    response()->json([
                        'status' => 200,
                        'message' => 'Solicitud de Firma indicado.',
                        'data' => $solicitud
                    ], 200) :
                    response()->json([
                        'status' => 200,
                        'message' => 'No se encontro la Solicitud de Firma.',
                        'data' => null
                    ], 200);
            } else {
                return response()->json([
                    'status' => 422,
                    'message' => 'El id ingresado es incorrecto.',
                    'data' => 'UUID Formato incorrecto.'
                ], 422);
            }
        } catch (Exception $e) {
            return response()->json([
                'status' => $e->getCode(),
                'message' => 'Ocurrio un error.',
                'data' => $e->getMessage()
            ], 400);
        }
    }

    public function actualizarSolicitudFirma(Request $request, $solicitudFirma_id)
    {
        try {
            // $this->authorize('actualizar-solicitud');
            $solicitud = $this->solicitud_firma->update($solicitudFirma_id, $request->all());
            if ($solicitud != null) {
                return response()->json([
                    'status' => 200,
                    'message' => 'Se actualizo correctamente los datos de solicitud de firma.',
                    'data' => $solicitud
                ]);
            } else {
                return response()->json([
                    'status' => 404,
                    'message' => 'No se encontro la solicitud de firma.',
                    'data' => null
                ], 404);
            }
        } catch (AuthorizationException $ae) {
            return response()->json([
                'status' => $ae->getCode(),
                'message' => 'No tiene permisos!.',
                'data' => $ae->getMessage()
            ]);
        } catch (Exception $e) {
            return response()->json([
                'status' => $e->getCode(),
                'message' => 'Ocurrio un error!.',
                'data' => $e->getMessage()
            ]);
        }
    }

    public function destroy(SolicitudFirma $solicitudFirma)
    {
        //
    }

    public function listarSolicitudesFirmaNuevas(Request $request)
    {
        try {
            // $this->authorize('listar-solicitudes-nuevas');
            $request->merge([
                'page' => $request->input('page', 0) + 1
            ]);
            if ($this->solicitud_firma->getSolicitutesNuevas($request)->count() == 0) {
                return response()->json([
                    'status' => 200,
                    'message' => 'No hay Solicitudes de Firma.',
                    'data' => null
                ], 200);
            } else {
                return response()->json([
                    'status' => 200,
                    'message' => 'Lista de Solicitudes de Firma.',
                    'data' => $this->solicitud_firma->getSolicitutesNuevas($request)
                ], 200);
            }
        } catch (AuthorizationException $ae) {
            return response()->json([
                'status' => $ae->getCode(),
                'message' => 'No tiene permisos!',
                'data' => $ae->getMessage()
            ], 401);
        } catch (Exception $e) {
            return response()->json([
                'status' => $e->getCode(),
                'message' => 'Ocurrio un error!',
                'data' => $e->getMessage()
            ], 400);
        }
    }

    public function listarSolicitudesFirmaNuevasEntidad(Request $request)
    {
        try {
            // $this->authorize('listar-solicitudes-nuevas-entidad');
            $request->merge([
                'page' => $request->input('page', 0) + 1
            ]);
            if ($this->solicitud_firma->getSolicitutesNuevasEntidad($request)->count() == 0) {
                return response()->json([
                    'status' => 200,
                    'message' => 'No hay Solicitudes de Firma.',
                    'data' => null
                ], 200);
            } else {
                return response()->json([
                    'status' => 200,
                    'message' => 'Lista de Solicitudes de Firma.',
                    'data' => $this->solicitud_firma->getSolicitutesNuevasEntidad($request)
                ], 200);
            }
        } catch (AuthorizationException $ae) {
            return response()->json([
                'status' => $ae->getCode(),
                'message' => 'No tiene permisos!',
                'data' => $ae->getMessage()
            ], 401);
        } catch (Exception $e) {
            return response()->json([
                'status' => $e->getCode(),
                'message' => 'Ocurrio un error!',
                'data' => $e->getMessage()
            ], 400);
        }
    }
    //Listar todas Solicitudes de Firma por Caducar en 15 dias de todas las entidades
    public function listarSolicitudesQuince(Request $request)
    {
        try {
            // $this->authorize('listar-solicitud-firma-administrador');
            $request->merge([
                'page' => $request->input('page', 0) + 1
            ]);
            $solicitudes = $this->solicitud_firma->getSolicitutesQuince($request);

            if ($solicitudes->total() > 0) {
                return response()->json([
                    'status' => 200,
                    'message' => 'Lista de Solicitudes de Firma.',
                    'data' => $solicitudes
                ], 200);
            } else {
                return response()->json([
                    'status' => 200,
                    'message' => 'No se encontraron solicitudes por caducar dentro de los 15 dias.',
                    'data' => null
                ], 200);
            }
        } catch (AuthorizationException $ae) {
            return response()->json([
                'status' => $ae->getCode(),
                'message' => 'No tiene permisos.',
                'data' => $ae->getMessage()
            ], 401);
        } catch (Exception $th) {
            return response()->json([
                'status' => $th->getCode(),
                'message' => 'Ocurrio un error.',
                'data' => $th->getMessage()
            ], 400);
        }
    }

    //Listar Solicitudes de Firma que caducan en 15 dias para la entidad del usuario logueado
    public function listarSolicitudesCaducanQuinceEntidad(Request $request)
    {
        try {
            // $this->authorize('listar-solicitud-firma-socio');
            $request->merge([
                'page' => $request->input('page', 0) + 1
            ]);
            $solicitudes = $this->solicitud_firma->getCaducanQuinceAuth($request);
            if ($solicitudes->count() > 0) {
                return response()->json([
                    'status' => 200,
                    'message' => 'Lista de Solicitudes de Firma.',
                    'data' => $solicitudes
                ], 200);
            } else {
                return response()->json([
                    'status' => 200,
                    'message' => 'No se encontraron solicitudes por caducar dentro de los 15 dias.',
                    'data' => null
                ], 200);
            }
        } catch (AuthorizationException $ae) {
            return response()->json([
                'status' => $ae->getCode(),
                'message' => 'No tiene permisos.',
                'data' => $ae->getMessage()
            ], 401);
        } catch (Exception $th) {
            return response()->json([
                'status' => $th->getCode(),
                'message' => 'Ocurrio un error.',
                'data' => $th->getMessage()
            ], 400);
        }
    }
    //Listar Solicitudes de Firma que caducan en 15 dias que son solicitadas por usuario logueado
    public function listarSolicitudesCaducanQuinceUsuario(Request $request)
    {
        try {
            // $this->authorize('listar-solicitud-firma-solicita');
            $request->merge([
                'page' => $request->input('page', 0) + 1
            ]);
            $solicitudes = $this->solicitud_firma->getCaducanQuinceGeneraAuth($request);
            if ($solicitudes->count() > 0) {
                return response()->json([
                    'status' => 200,
                    'message' => 'Lista de Solicitudes de Firma.',
                    'data' => $solicitudes
                ], 200);
            } else {
                return response()->json([
                    'status' => 200,
                    'message' => 'No se encontraron solicitudes por caducar dentro de los 15 dias.',
                    'data' => null
                ], 200);
            }
        } catch (AuthorizationException $ae) {
            return response()->json([
                'status' => $ae->getCode(),
                'message' => 'No tiene permisos.',
                'data' => $ae->getMessage()
            ], 401);
        } catch (Exception $th) {
            return response()->json([
                'status' => $th->getCode(),
                'message' => 'Ocurrio un error.',
                'data' => $th->getMessage()
            ], 400);
        }
    }
    //Listar Solicitudes de Firma que caducan en 7 dias de todas la entidades
    public function listarSolicitudesSiete(Request $request)
    {
        try {
            $request->merge([
                'page' => $request->input('page', 0) + 1
            ]);
            $solicitudes = $this->solicitud_firma->getSolicitutesSiete($request);
            if ($solicitudes->count() > 0) {
                return response()->json([
                    'status' => 200,
                    'message' => 'Lista de Solicitudes de Firma.',
                    'data' => $solicitudes
                ], 200);
            } else {
                return response()->json([
                    'status' => 200,
                    'message' => 'No se encontraron solicitudes por caducar dentro de los 7 dias.',
                    'data' => null
                ], 200);
            }
        } catch (AuthorizationException $ae) {
            return response()->json([
                'status' => $ae->getCode(),
                'message' => 'No tiene permisos.',
                'data' => $ae->getMessage()
            ], 401);
        } catch (Exception $th) {
            return response()->json([
                'status' => $th->getCode(),
                'message' => 'Ocurrio un error.',
                'data' => $th->getMessage()
            ], 400);
        }
    }
    //Listar Solicitudes de Firma que caducan en 7 dias para la entidad del usuario logueado
    public function listarSolicitudesCaducanSieteEntidad(Request $request)
    {
        try {
            // $this->authorize('listar-solicitud-firma-socio');
            $request->merge([
                'page' => $request->input('page', 0) + 1
            ]);
            $solicitudes = $this->solicitud_firma->getCaducanSieteAuth($request);
            if ($solicitudes->count() > 0) {
                return response()->json([
                    'status' => 200,
                    'message' => 'Lista de Solicitudes de Firma.',
                    'data' => $solicitudes
                ], 200);
            } else {
                return response()->json([
                    'status' => 200,
                    'message' => 'No se encontraron solicitudes por caducar dentro de los 7 dias.',
                    'data' => null
                ], 200);
            }
        } catch (AuthorizationException $ae) {
            return response()->json([
                'status' => $ae->getCode(),
                'message' => 'No tiene permisos.',
                'data' => $ae->getMessage()
            ], 401);
        } catch (Exception $th) {
            return response()->json([
                'status' => $th->getCode(),
                'message' => 'Ocurrio un error.',
                'data' => $th->getMessage()
            ], 400);
        }
    }
    //Listar Solicitudes de Firma que caducan en 7 dias que son solicitadas por usuario logueado
    public function listarSolicitudesCaducanSieteUsuario(Request $request)
    {
        try {
            // $this->authorize('listar-solicitud-firma-solicita');
            $request->merge([
                'page' => $request->input('page', 0) + 1
            ]);
            $solicitudes = $this->solicitud_firma->getCaducanSieteGeneraAuth($request);
            if ($solicitudes->count() > 0) {
                return response()->json([
                    'status' => 200,
                    'message' => 'Lista de Solicitudes de Firma.',
                    'data' => $solicitudes
                ], 200);
            } else {
                return response()->json([
                    'status' => 200,
                    'message' => 'No se encontraron solicitudes por caducar dentro de los 7 dias.',
                    'data' => null
                ], 200);
            }
        } catch (AuthorizationException $ae) {
            return response()->json([
                'status' => $ae->getCode(),
                'message' => 'No tiene permisos.',
                'data' => $ae->getMessage()
            ], 401);
        } catch (Exception $th) {
            return response()->json([
                'status' => $th->getCode(),
                'message' => 'Ocurrio un error.',
                'data' => $th->getMessage()
            ], 400);
        }
    }

    public function buscarSolicitudesFirmaIdentificacion(Request $request)
    {
        try {
            // $this->authorize('buscar-solicitudes');
            $request->merge([
                'page' => $request->input('page', 0) + 1
            ]);
            $solicitudes = $this->solicitud_firma->getFirmasIdentificacion($request, $request->numero_identificacion);
            if ($solicitudes->count() > 0) {
                return response()->json([
                    'status' => 200,
                    'message' => 'Lista de Solicitudes de Firma.',
                    'data' => $solicitudes
                ], 200);
            } else {
                return response()->json([
                    'status' => 200,
                    'message' => 'No se encontraron solicitudes de firma.',
                    'data' => null
                ], 200);
            }
        } catch (AuthorizationException $ae) {
            return response()->json([
                'status' => $ae->getCode(),
                'message' => 'No tiene permisos.',
                'data' => $ae->getMessage()
            ], 401);
        } catch (Exception $th) {
            return response()->json([
                'status' => $th->getCode(),
                'message' => 'Ocurrio un error.',
                'data' => $th->getMessage()
            ], 400);
        }
    }

    public function buscarSolicitudesFirmaIdentificacionEntidad(Request $request)
    {
        try {
            // $this->authorize('buscar-solicitudes-entidad');
            $request->merge([
                'page' => $request->input('page', 0) + 1
            ]);
            $solicitudes = $this->solicitud_firma->getFirmasIdentificacionEntidad($request, $request->numero_identificacion);

            if ($solicitudes->count() > 0) {
                return response()->json([
                    'status' => 200,
                    'message' => 'Lista de Solicitudes de Firma.',
                    'data' => $solicitudes
                ], 200);
            } else {
                return response()->json([
                    'status' => 200,
                    'message' => 'No se encontraron solicitudes de firma.',
                    'data' => null
                ], 200);
            }
        } catch (AuthorizationException $ae) {
            return response()->json([
                'status' => $ae->getCode(),
                'message' => 'No tiene permisos.',
                'data' => $ae->getMessage()
            ], 401);
        } catch (Exception $th) {
            return response()->json([
                'status' => $th->getCode(),
                'message' => 'Ocurrio un error.',
                'data' => $th->getMessage()
            ], 400);
        }
    }

    public function buscarSolicitudesFirmaIdentificacionUsuarioSolicita(Request $request)
    {
        try {
            // $this->authorize('buscar-solicitudes-usuario');
            $request->merge([
                'page' => $request->input('page', 0) + 1
            ]);
            $solicitudes = $this->solicitud_firma->getFirmasIdentificacionUsuarioSolicita($request, $request->numero_identificacion);
            if ($solicitudes->count() > 0) {
                return response()->json([
                    'status' => 200,
                    'message' => 'Lista de Solicitudes de Firma.',
                    'data' => $solicitudes
                ], 200);
            } else {
                return response()->json([
                    'status' => 200,
                    'message' => 'No se encontraron solicitudes de firma.',
                    'data' => null
                ], 200);
            }
        } catch (AuthorizationException $ae) {
            return response()->json([
                'status' => $ae->getCode(),
                'message' => 'No tiene permisos.',
                'data' => $ae->getMessage()
            ], 401);
        } catch (Exception $th) {
            return response()->json([
                'status' => $th->getCode(),
                'message' => 'Ocurrio un error.',
                'data' => $th->getMessage()
            ], 400);
        }
    }

    public function listarSolicitudesEntidad(Request $request)
    {
        try {
            // $this->authorize('listar-solicitudes-entidad');
            $request->merge([
                'page' => $request->input('page', 0) + 1
            ]);
            $solicitudes = $this->solicitud_firma->getSolicitudesEntidad($request);
            if ($solicitudes->count() > 0) {
                return response()->json([
                    'status' => 200,
                    'message' => 'Lista de Solicitudes de Firma.',
                    'data' => $solicitudes
                ], 200);
            } else {
                return response()->json([
                    'status' => 200,
                    'message' => 'No se encontraron solicitudes de firma.',
                    'data' => null
                ], 200);
            }
        } catch (AuthorizationException $ae) {
            return response()->json([
                'status' => $ae->getCode(),
                'message' => 'No tiene permisos.',
                'data' => $ae->getMessage()
            ], 401);
        } catch (Exception $th) {
            return response()->json([
                'status' => $th->getCode(),
                'message' => 'Ocurrio un error.',
                'data' => $th->getMessage()
            ], 400);
        }
    }

    public function listarSolicitudesUsuarioSolicita(Request $request)
    {
        try {
            // $this->authorize('listar-solicitudes-usuario');
            $request->merge([
                'page' => $request->input('page', 0) + 1
            ]);
            $solicitudes = $this->solicitud_firma->getSolicitudesUsuarioSolicita($request);
            if ($solicitudes->count() > 0) {
                return response()->json([
                    'status' => 200,
                    'message' => 'Lista de Solicitudes de Firma.',
                    'data' => $solicitudes
                ], 200);
            } else {
                return response()->json([
                    'status' => 200,
                    'message' => 'No se encontraron solicitudes de firma.',
                    'data' => null
                ], 200);
            }
        } catch (AuthorizationException $ae) {
            return response()->json([
                'status' => $ae->getCode(),
                'message' => 'No tiene permisos.',
                'data' => $ae->getMessage()
            ], 401);
        } catch (Exception $th) {
            return response()->json([
                'status' => $th->getCode(),
                'message' => 'Ocurrio un error.',
                'data' => $th->getMessage()
            ], 400);
        }
    }

    public function actualizarSolicitudEntidad(Request $request, $id)
    {
        try {
            // $this->authorize('actualizar-solicitud-entidad');
            $solicitud = $this->solicitud_firma->updateSolicitudEntidad($id, $request->all());
            if ($solicitud != null) {
                return response()->json([
                    'status' => 200,
                    'message' => 'Solicitud de Firma actualizada.',
                    'data' => $solicitud
                ], 200);
            } else {
                return response()->json([
                    'status' => 404,
                    'message' => 'No se encontro la solicitud indicada.',
                    'data' => null
                ], 404);
            }
        } catch (AuthorizationException $ae) {
            return response()->json([
                'status' => $ae->getCode(),
                'message' => 'No tiene permisos.',
                'data' => $ae->getMessage()
            ], 401);
        } catch (Exception $th) {
            return response()->json([
                'status' => $th->getCode(),
                'message' => 'Ocurrio un error.',
                'data' => $th->getMessage()
            ], 400);
        }
    }

    public function actualizarSolicitudUsuarioSolicita(Request $request, $id)
    {
        try {
            // $this->authorize('actualizar-solicitud-usuario');
            $solicitud = $this->solicitud_firma->updateSolicitudUsuarioSolicita($id, $request->all());
            if ($solicitud != null) {
                return response()->json([
                    'status' => 200,
                    'message' => 'Solicitud de Firma actualizada.',
                    'data' => $solicitud
                ], 200);
            } else {
                return response()->json([
                    'status' => 404,
                    'message' => 'No se encontro la solicitud indicada.',
                    'data' => null
                ], 404);
            }
        } catch (AuthorizationException $ae) {
            return response()->json([
                'status' => $ae->getCode(),
                'message' => 'No tiene permisos.',
                'data' => $ae->getMessage()
            ], 401);
        } catch (Exception $th) {
            return response()->json([
                'status' => $th->getCode(),
                'message' => 'Ocurrio un error.',
                'data' => $th->getMessage()
            ], 400);
        }
    }

    public function export()
    {
        return Excel::download(new SolicitudesExport(), 'users.xlsx');
    }
}
