<?php

namespace App\Http\Controllers;

use App\Models\Contacto;
use App\Models\ApiCoorporativo;
use App\Models\Usuario;
use App\Models\ValidarIdentificacion;
use Carbon\Carbon;
use Exception;
use Illuminate\Auth\Access\AuthorizationException;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Str;

class SolicitudNuevaController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth:api');
    }
    public function crearNuevaSolicitud(Request $request)
    {
        try {
            $validator = Validator::make($request->all(), [
                'token_api' => 'required',
                'clave_api' => 'required',
                'email' => 'required',
                'cedula' => 'required',
                'telefono' => 'required',
                'requiere_firma' => 'required',
                'requiere_facturacion' => 'required',
            ]);

            if ($validator->fails()) {
                return response()->json([
                    'status' => 422,
                    'message' => 'Error al validar los datos de entrada.',
                    'data' => $validator->errors()
                ], 422);
            } else {
                // $token_api=ApiCoorporativo::find($request->token_api);
                // $clave_api=ApiCoorporativo::find($request->clave_api);
                // $validarIdentificacion=new ValidarIdentificacion();
                // $validarCedula=$validarIdentificacion->validarCedula($request->cedula);
                // $tipo_firma_id=$request->tipo_firma_id;
                // $numero_facturas=$request->numero_facturas;
                // $nombre_comercial=$request->nombre_comercial;
                // $requiere_firma=$request->requiere_firma;
                // $requiere_facturacion=$request->requiere_facturacion;

                // if($requiere_firma){
                //     if(!$tipo_firma_id){
                //         return response()->json([
                //             'status' => 422,
                //             'message' => 'Error al validar los datos de entrada.',
                //             'data' => 'Tipo de firma es requerido'
                //         ], 422);
                //     }
                // }

                // if($requiere_facturacion){
                //     if(!$numero_facturas){
                //         return response()->json([
                //             'status' => 422,
                //             'message' => 'Error al validar los datos de entrada.',
                //             'data' => 'Número de facturas es requerido'
                //         ], 422);
                //     }
                //     if(!$nombre_comercial){
                //         return response()->json([
                //             'status' => 422,
                //             'message' => 'Error al validar los datos de entrada.',
                //             'data' => 'Nombre comercial es requerido'
                //         ], 422);
                //     }
                // }

                // if(!$validarCedula){
                //     return response()->json([
                //         'status' => 422,
                //         'message' => 'Error al validar los datos de entrada.',
                //         'data' => 'Cédula Inválida'
                //     ], 422);
                // }

                // if($entidad_comercial){
                //     $solicitudes_iniciales = SolicitudesIniciales::create([
                //         'cedula' => $request->cedula,
                //         'email' => $request->email,
                //         'telefono' => $request->celular,
                //         'entidad_id' => $entidad_comercial->id,
                //         'estado' => 'NUEVO',
                //     ]);

                // }else{
                //     return response()->json([
                //         'status' => 422,
                //         'message' => 'Error al validar los datos de entrada.',
                //         'data' => 'No se encontro entidad comercial autorizada'
                //     ], 422);
                // }
                return response()->json([
                    'status' => 201,
                    'message' => 'Solicitud creada correctamente.',
                    'data' => $solicitudes_iniciales
                ], 201);
            }
        } catch (AuthorizationException $th) {
            return response()->json([
                'status'=>$th->getCode(),
                'message'=>'No autorizado!.',
                'data'=>$th->getMessage()
            ],401);
        } catch(Exception $e){
            return response()->json([
                'status'=>$e->getCode(),
                'message'=>'Ocurrio un error!.',
                'data'=>$e->getMessage()
            ],400);
        }
    }

}
