<?php

namespace App\Http\Controllers;

use App\Http\Requests\SolicitudFirmaRequest;
use App\Models\SolicitudPrevia;
use Carbon\Carbon;
use Exception;
use App\Repositories\AccionRepository;
use App\Repositories\EstadoSolicitudRepository;
use App\Repositories\SolicitudFirmaRepository;
use Illuminate\Auth\Access\AuthorizationException;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Str;
use Illuminate\Support\Facades\Mail;
use App\Mail\EmailSolicitudPrevia;
use App\Models\ApiCoorporativo;
use App\Models\PrecioFirma;
use App\Models\TipoFirma;

class SolicitudPreviaController extends Controller
{

    private $solicitud_firma;
    private $estado;
    private $accion;

    public function __construct(SolicitudFirmaRepository $solicitud_firma, EstadoSolicitudRepository $estado, AccionRepository $accion)
    {
        // $this->middleware('auth:api');
        $this->solicitud_firma = $solicitud_firma;
    }
    public function crearNuevaSolicitud(Request $request)
    {
       
        try {
            // $this->authorize('registrar-entidadesComerciales');
            $validator = Validator::make($request->all(), [
                'token_api' => 'required|exists:api_coorporativos,token',
                'clave_api' => 'required|exists:api_coorporativos,clave_coorporativo',
                'email' => 'required',
                'identificacion' => 'required',
                'telefono' => 'required',
                'tipo_firma_id' => 'required|exists:tipos_firmas,id',
                //'contenedor' => 'required',
                //'vigenciafirma' => 'required',
                //'precio' => 'required',
                'requiere_facturacion' => 'required',
                'numero_facturas' => 'required',
                'requiere_firma' => 'required',
                //'tipo_persona' => 'required'
            ]);
            //contenedor, vigencia, precio se obtienen con el "tipo_firma_id"
            //tipo de persona se obtiene de la identificación
            if ($validator->fails()) {
                return response()->json([
                    'status' => 422,
                    'message' => 'Error al validar los datos de entrada.1',
                    'data' => $validator->errors()
                ], 422);
            } else {
                $token = $request->input('token_api');
                $clave = $request->input('clave_api');

                $api = ApiCoorporativo::where('token', $token)
                    ->where('clave_coorporativo', $clave)
                    ->first();
                    
                    
                    $tipoFirma = TipoFirma::where('id', $request->tipo_firma_id)
                      ->first();

                    if (!$tipoFirma) {
                        return response()->json([
                            'status' => 404,
                            'message' => 'Tipo de firma no encontrado.'
                        ]);
                    }
                    $infor = $tipoFirma->tipo_firma;
                    // dd($infor);
                    if ($tipoFirma) {
                        switch ($infor) {
                            case 'ARCHIVO':
                                $contenedor = 1;
                                break;
    
                            case 'TOKEN':
                                $contenedor = 2;
                                break;
    
                            case 'NUBE':
                                $contenedor = 3;
                                break;
    
                            default:
                                $contenedor = 0;
                                break;
                        }
                    } else {
                        // Maneja el caso en el que no se encuentre ningn registro con el precio_firma_id proporcionado
                    }
                    
                    // Asignar los valores obtenidos desde el tipo de firma
                   // $contenedor = $tipoFirma->contenedor;
                    $vigenciafirma = $tipoFirma->tiempo_validez;
                    $precio = 0;
                    $identificacion = $request->identificacion;

                    if (strlen($identificacion) === 13 && ($identificacion[2] === '9'||$identificacion[2] === '6')) {
                        $tipo_persona = "REPRESENTANTE LEGAL";
                    } elseif (strlen($identificacion) === 13) {
                        $tipo_persona = "PERSONA NATURAL CON RUC";
                    } else {
                        $tipo_persona = "PERSONA NATURAL";
                    }

                $solicitud_previa = SolicitudPrevia::create([
                    'solicitud_id' => null,
                    'email' => $request->email,
                    'identificacion' => $request->identificacion,
                    'telefono' => $request->telefono,
                    'usuario_corp' => "154f5aae-bf80-42ba-b836-df1e21342134",
                    'entidad_id' => $api->entidad_id,
                    'estado' => true,
                    //'contenedor' => $request->contenedor,
                    //'vigenciafirma' => $request->vigenciafirma,
                    //'precio' => $request->precio,
                    'contenedor' => $contenedor,
                    'vigenciafirma' => $vigenciafirma,
                    'precio' => $precio,
                    'requiere_facturacion' => $request->requiere_facturacion,
                    'numero_facturas' => $request->numero_facturas,
                    'requiere_firma' => $request->requiere_firma,
                    'uanataca_id' => $request->uanataca_id,
                    'tipo_persona' => $tipo_persona,
                    'tipo_solicitud' => "NUEVA"
                ]);

                //consultar solicitud previa con la data completa y enviar al correo 

                $destinatario = $request->email;
                Mail::to($destinatario)->send(new EmailSolicitudPrevia($solicitud_previa));

                return response()->json([
                    'status' => 201,
                    'message' => 'Solicitud previa creada correctamente.',
                    'data' => $solicitud_previa
                ], 201);
            }
        } catch (AuthorizationException $th) {
            return response()->json([
                'status' => $th->getCode(),
                'message' => 'No autorizado!.',
                'data' => $th->getMessage()
            ], 401);
        } catch (Exception $e) {
            return response()->json([
                'status' => $e->getCode(),
                'message' => 'Ocurrio un error!.',
                'data' => $e->getMessage()
            ], 400);
        }
    }

    public function buscarSolicitud($solicitudFirma_id)
    {
        try {
            if (Str::isUuid($solicitudFirma_id) == true) {
                $solicitud = SolicitudPrevia::find($solicitudFirma_id);
                return ($solicitud != null) ?
                    response()->json([
                        'status' => 200,
                        'message' => 'Solicitud de Firma previa indicado.',
                        'data' => $solicitud
                    ], 200) :
                    response()->json([
                        'status' => 200,
                        'message' => 'No se encontro la Solicitud de Firma previa.',
                        'data' => null
                    ], 200);
            } else {
                return response()->json([
                    'status' => 422,
                    'message' => 'El id ingresado es incorrecto.',
                    'data' => 'UUID Formato incorrecto.'
                ], 422);
            }
        } catch (Exception $e) {
            return response()->json([
                'status' => $e->getCode(),
                'message' => 'Ocurrio un error.',
                'data' => $e->getMessage()
            ], 400);
        }
    }


    public function listarSolicitudes(Request $request)
    {
        try {
            $validator = Validator::make($request->all(), [
                'token_api' => 'required|exists:api_coorporativos,token',
                'clave_api' => 'required|exists:api_coorporativos,clave_coorporativo'
            ]);
            if ($validator->fails()) {
                return response()->json([
                    'status' => 404,
                    'message' => 'Error al validar los datos de entrada.',
                    'data' => $validator->errors()
                ], 404);
            } else {
                $lst_solicitudes = SolicitudPrevia::where('identificacion', $request->identificacion)->get();
                if ($lst_solicitudes != null) {
                    return response()->json([
                        'status' => 200,
                        'message' => 'Lista de solicitudes del cliente. ',
                        'data' => $lst_solicitudes
                    ]);
                } else {
                    return response()->json([
                        'status' => 200,
                        'message' => 'No existe cliente. ',
                        'data' => $lst_solicitudes
                    ]);
                }
            }
        } catch (\Throwable $th) {
            return response()->json([
                'status' => $th->getCode(),
                'message' => 'Ocurrio un error!. ',
                'data' => $th->getMessage()
            ], $th->getCode());
        }
    }

    public function actualizarSolicitud(Request $request, $id)
    {
        try {
            $solicitud = SolicitudPrevia::find($id);
            if ($solicitud != null) {
                $solicitud->update($request->all());
                return response()->json([
                    'status' => 200,
                    'message' => 'Solicitud de Firma previa actualizada correctamente.',
                    'data' => $solicitud
                ], 200);
            } else {
                return response()->json([
                    'status' => 200,
                    'message' => 'No se encontro la Solicitud de Firma previa indicada.',
                    'data' => null
                ], 200);
            }
        } catch (AuthorizationException $th) {
            return response()->json([
                'status' => $th->getCode(),
                'message' => 'No autorizado!.',
                'data' => $th->getMessage()
            ], 401);
        } catch (Exception $e) {
            return response()->json([
                'status' => $e->getCode(),
                'message' => 'Ocurrio un error!.',
                'data' => $e->getMessage()
            ], 400);
        }
    }

    public function crearSolicitudFirma(SolicitudFirmaRequest $request)
    {
        try {
            // $this->authorize('registrar-solicitud');
            $solicitud_firma = $this->solicitud_firma->create($request->all());
            $this->accion->create([
                'solicitud_id' => $solicitud_firma->id,
                'nombre_accion' => 'Creo Soliciud de Firma',
                'descripcion' => 'Se creo nueva Soliciud de Firma',
            ]);
            $this->estado->create($request->all() + [
                'solicitud_id' => $solicitud_firma->id,
                'tipo_solicitud' => $solicitud_firma->tipo_solicitud,
                'estado' => 'NUEVO',
                'uid_proveedor' => 'TEST ***',
                'creado_por' => auth()->user()->id,
                'fecha_registro' => Carbon::now()
            ]);
            return response()->json([
                'status' => 201,
                'message' => 'Se creo correctamente la Solicitud Firma',
                'data' => $solicitud_firma->load('estado')
            ]);
        } catch (AuthorizationException $ae) {
            return response()->json([
                'status' => $ae->getCode(),
                'message' => 'No tiene permisos!',
                'data' => $ae->getMessage()
            ], 401);
        } catch (Exception $e) {
            return response()->json([
                'status' => $e->getCode(),
                'message' => 'Ocurrio un error!',
                'data' => $e->getMessage()
            ], 400);
        }
    }

    public function listarPreciosFirmasEntidad(Request $request)
    {
        try {
            $validator = Validator::make($request->all(), [
                'token_api' => 'required|exists:api_coorporativos,token',
                'clave_api' => 'required|exists:api_coorporativos,clave_coorporativo',
            ]);
            if ($validator->fails()) {
                return response()->json([
                    'status' => 422,
                    'message' => 'Error al validar los datos de entrada.',
                    'data' => $validator->errors()
                ], 422);
            } else {
                //consultar solicitud previa con la data completa y enviar al correo 
                $api = ApiCoorporativo::where('token', $request->token_api)
                    ->where('clave_coorporativo', $request->clave_api)
                    ->first();

                if ($api != null) {
                    $lst_precios = PrecioFirma::with('tipo_firma')
                        ->whereHas('entidad', function ($query) use ($api) {
                            $query->where('id', $api->entidad_id);
                        })
                        ->where('estado', true)
                        ->orderBy('pvp', 'asc')
                        ->get();

                    if ($lst_precios->count() > 0) {
                        return response()->json([
                            'status' => 200,
                            'message' => 'Lista de Precios de Firmas.',
                            'data' => $lst_precios
                        ]);
                    } else {
                        return response()->json([
                            'status' => 200,
                            'message' => 'No hay Precios de Firmas registrados.',
                            'data' => null
                        ]);
                    }
                } else {
                    response()->json([
                        'status' => 200,
                        'message' => 'No se encontro la Solicitud de Firma previa.',
                        'data' => null
                    ], 200);
                }
            }
        } catch (\Throwable $th) {
            return response()->json([
                'status' => $th->getCode(),
                'message' => 'Ocurrio un error!.',
                'data' => $th->getMessage()
            ], 400);
        }
    }
}
