<?php

namespace App\Http\Controllers;

use App\Interfaces\TipoFirmaRepositoryInterface;
use App\Models\TipoFirma;
use App\Repositories\TipoFirmaRepository;
use Illuminate\Http\Request;
use App\Models\ApiCorporativo;
use App\Models\PrecioFirma;


class TipoFirmaController extends Controller
{
    private $tipofirma;

    public function __construct(TipoFirmaRepository $tipofirma) 
    {
        $this->tipofirma = $tipofirma;
        $this->middleware('auth');
    }

    public function listarTiposFirmas()
    {
        try {
            return ($this->tipofirma->getAllTiposFirmas() != null) ?
                response()->json([
                    'status' => 200,
                    'message' => 'Listado de Tipos de Firmas.',
                    'data' => $this->tipofirma->getAllTiposFirmas()
                ]) :
                response()->json([
                    'status' => 200,
                    'message' => 'No hay Tipos de Firmas Registradas.',
                    'data' => null
                ]);
        } catch (\Throwable $th) {
            response()->json([
                'status' => $th->getCode(),
                'message' => 'Ocurrio un error!.',
                'data' => $th->getMessage()
            ],400);
        }
    }
    
    
}
