<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class EstadoSolicitudRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, mixed>
     */
    public function rules()
    {
        return [
            //
        ];
    }

    protected function createRules()
    {
        return [
            'solicitud_id' => 'required|uuid',
            'tipo_solicitud' => 'required|string',
            'estado' => 'required|string',
            'observacion' => 'nullable|string',
            'fecha_vencimiento' => 'nullable|string',
            'uid_proveedor' => 'required|string',
            'creado_por' => 'required|string',
            'fecha_registro' => 'required|string',
            'pago_id' => 'nullable|string',
            'fecha_pago' => 'nullable|string',
            'precio' => 'nullable|string',
            'num_factura' => 'nullable|string',
            'pagado' => 'required|boolean',
        ];
    }
    protected function update()
    {
        return [
            'solicitud_id' => 'uuid',
            'tipo_solicitud' => 'string',
            'estado' => 'string',
            'observacion' => 'nullable|string',
            'fecha_vencimiento' => 'nullable|string',
            'uid_proveedor' => 'string',
            'creado_por' => 'string',
            'fecha_registro' => 'string',
            'pago_id' => 'nullable|string',
            'fecha_pago' => 'nullable|string',
            'precio' => 'nullable|string',
            'num_factura' => 'nullable|string',
            'pagado' => 'boolean',
        ];
    }
}
