<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class FirmaEmpresarialRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, mixed>
     */
    public function rules()
    {
        return [
            'solicitud_id'=>'required|uuid|exists:solicitudes_firmas,id',
            'ruc_empresa'=>'required|string',
            'empresa'=>'required|string',
            'cargo'=>'required|string',
            'motivo'=>'required|string',
            'unidad'=>'required|string',
            'nombresRL'=>'required|string',
            'apellidosRL'=>'required|string',
            'numerodocumentoRL'=>'required|string',
            'tipodocumentoRL'=>'required|string',
            'f_documentoRL'=>'required|url',
            'f_autreprelegal'=>'required|url',
            'f_nombramiento'=>'required|url',
            'f_nombremiento2'=>'nullable|url',
            'f_constitucion'=>'required|url'
        ];
    }
}
