<?php

namespace App\Http\Requests;

use App\Enum\VigenciaFirmaEnum;
use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\Rules\Enum;

class SolicitudFirmaRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, mixed>
     */
    public function rules()
    {
        return [
            'numerodocumento'=>'required',
            'nombres'=>'required|string',
            'apellido1'=>'required|string',
            'apellido2'=>'required|string',
            'tipodocumento'=>'required|in:CEDULA,PASAPORTE',
            'tipo_solicitud'=>'required|in:PERSONA NATURAL,MIEMBRO DE EMPRESA,REPRESENTANTE LEGAL,PERSONA JURIDICA',
            'coddactilar'=>'required',
            'ruc_personal'=>'nullable',
            'sexo'=>'required|string|in:HOMBRE,MUJER',
            'contenedor'=>'required|numeric|in:1,2,3',
            'fecha_nacimiento'=>'required|date',
            'nacionalidad'=>'required|string',
            'telfCelular'=>'required|string',
            'telfFijo'=>'nullable|string',
            'eMail'=>'required|email',
            'telfCelular2'=>'nullable|string',
            'provincia'=>'required|string',
            'ciudad'=>'required|string',
            'direccion'=>'required|string',
            'vigenciafirma'=>[new Enum(VigenciaFirmaEnum::class)],
            'f_cedulaFront'=>'required|url',
            'entidad_solicitante'=>'uuid|exists:entidades,id',
            'usuario_solicita'=>'uuid|exists:usuarios,id',
            'f_cedulaBack'=>'required|url',
            'f_selfie'=>'required|url',
            'f_copiaruc'=>'nullable|url',
            'f_adicional1'=>'nullable|url',
            'f_adicional2'=>'nullable|url',
            'f_adicional3'=>'nullable|url',
            'f_adicional4'=>'nullable|url'
        ];
    }
}
