<?php

namespace App\Models;

use App\Traits\Uuid;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class Acceso extends Model
{
    use HasFactory,Uuid;
    protected $table = 'accesos';
    public $incrementing = false;
    protected $keyType = 'uuid';
    protected $fillable =[
        'usuario_id',
        'fecha',
        'ip_acceso'
    ];

    public function usuario():BelongsTo
    {
        return $this->belongsTo(Usuario::class,'usuario_id');
    }
}
