<?php

namespace App\Models;

use App\Traits\Uuid;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class Accion extends Model
{
    use HasFactory,Uuid;
    protected $table = 'acciones';
    public $incrementing = false;
    protected $keyType = 'uuid';
    public $timestamps = false;
    protected $fillable =[
        'solicitud_id',
        'usuario_registra',
        'nombre_accion',
        'descripcion',
        'fecha',
    ];

    public function solicitud(): BelongsTo
    {
        return $this->belongsTo(SolicitudFirma::class,'solicitud_id');
    }
    public function usuario_registra(): BelongsTo
    {
        return $this->belongsTo(Usuario::class,'usuario_registra');
    }
    

}
