<?php

namespace App\Models;

use App\Traits\Uuid;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class DiagnosticoDispositivo extends Model
{
    use HasFactory, Uuid;
    protected $table = 'diagnostico_dispositivo';
    public $incrementing = false;
    protected $keyType = 'uuid';
    protected $fillable = [
        'dispositivo_id',
        'observaciones_diagnostico',
        'estado_diagnostico',
        'version_apk_instalada',
        'ip_publica',
        'estado_camara',
        'nivel_bateria',
        'estado_impresora',
        'velocidad_subida',
        'velocidad_bajada',
        'tipo_conexion',
    ];

    public function dispositivo(): BelongsTo
    {
        return $this->belongsTo(Dispositivo::class, 'dispositivo_id');
    }
}
