<?php

namespace App\Models;

use App\Traits\Uuid;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class EstadoSolicitud extends Model
{
    use HasFactory,Uuid;
    protected $table = 'estados_solicitudes';
    public $incrementing = false;
    protected $keyType = 'uuid';

    protected $fillable = [
        'solicitud_id',
        'tipo_solicitud',
        'estado',
        'observacion',
        'fecha_vencimiento',
        'uid_proveedor',
        'creado_por',
        'fecha_registro',
        'pago_id',
        'fecha_pago',
        'precio',
        'num_factura',
        'pagado',
    ];

    public function solicitud():BelongsTo
    {
        return $this->belongsTo(SolicitudFirma::class,'solicitud_id');
    }

    
}
