<?php

namespace App\Models;

use App\Traits\Uuid;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class Facturacion extends Model
{
    use HasFactory, Uuid;
    protected $table = 'facturacion';
    public $incrementing = false;
    protected $keyType = 'uuid';
    protected $fillable = [
        'numero_factura',
        'cliente',
        'identificacion',
        'total',
        'pago_id',
        'detalle',
        'estado',
        'clave_acceso',
        'mensaje',
    ];

    public function pago(): BelongsTo
    {
        return $this->belongsTo(Pago::class, 'pago_id');
    }
}
