<?php

namespace App\Models;

use App\Traits\Uuid;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class FirmaRepresentanteLegal extends Model
{
    use HasFactory,Uuid;
    protected $table = 'firmas_representantes_legales';
    public $incrementing = false;
    protected $keyType = 'uuid';
    protected $fillable =[
        'solicitud_id',
        'ruc_empresa',
        'empresa',
        'cargo',
        'f_nombramiento',
        'f_nombramiento2',
        'f_constitucion'
    ];

    public function solicitud():BelongsTo
    {
        return $this->belongsTo(SolicitudFirma::class,'solicitud_id');
    }
}
