<?php

namespace App\Models;

use App\Traits\Uuid;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class LogDispositivo extends Model
{
    use HasFactory, Uuid;
    protected $table = 'log_dispositivo';
    public $incrementing = false;
    protected $keyType = 'uuid';
    protected $fillable = [
        'dispositivo_id',
        'descripcion',
        'fecha_log',
        'tipo_log',
    ];

    public function dispositivo(): BelongsTo
    {
        return $this->belongsTo(Dispositivo::class, 'dispositivo_id');
    }
}
