<?php

namespace App\Models;

use App\Traits\Uuid;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class PrecioFirma extends Model
{
    use HasFactory, Uuid;
    protected $table = 'precios_firmas';
    public $incrementing = false;
    protected $keyType = 'uuid';
    protected $fillable = [
        'entidad_id',
        'precio',
        'pvp',
        'tipo_firma_id',
        'fecha_inicio',
        'fecha_fin',
        'estado',
        'usuario_registra',
        'disc_renovacion',
        'disc_serv_publicos'
    ];

    public function usuario_registra(): BelongsTo
    {
        return $this->belongsTo(Usuario::class, 'usuario_registra');
    }
    public function entidad(): BelongsTo
    {
        return $this->belongsTo(EntidadComercial::class, 'entidad_id');
    }
    public function tipo_firma(): BelongsTo
    {
        return $this->belongsTo(TipoFirma::class, 'tipo_firma_id');
    }
}
