<?php

namespace App\Models;

use App\Traits\Uuid;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasMany;

class RegistroLote extends Model
{
    use HasFactory,Uuid;
    protected $table = 'registro_lotes';
    public $incrementing = false;
    protected $keyType = 'uuid';
    public $timestamps = false;
    protected $fillable = [
        'usuario_registra',
        'entidad_id',
        'fecha_carga',
        'archivo_url',
        'finalizado'
    ];

    public function usuario_registra():BelongsTo
    {
        return $this->belongsTo(Usuario::class,'usuario_registra');
    }

    public function entidad_id():BelongsTo
    {
        return $this->belongsTo(EntidadComercial::class,'entidad_id');
    }

    public function solicitud_lote():HasMany
    {
        return $this->hasMany(SolicitudLote::class,'lote_id');
    }
}
