<?php

namespace App\Models;

use App\Traits\Uuid;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class SolicitudLote extends Model
{
    use HasFactory,Uuid;
    protected $table = 'solicitudes_lote';
    public $incrementing = false;
    protected $keyType = 'uuid';
    public $timestamps = false;
    protected $fillable = [
        'lote_id',
        'solicitud_id',
        'estado'
    ];

    public function lote():BelongsTo
    {
        return $this->belongsTo(RegistroLote::class,'lote_id');
    }

    public function solicitud_id():BelongsTo
    {
        return $this->belongsTo(SolicitudFirma::class,'solicitud_id');
    }
}
