<?php

namespace App\Models;

use App\Traits\Uuid;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasMany;

class SolicitudesIniciales extends Model
{
    use HasFactory,Uuid;
    protected $table = 'solicitudes_iniciales';
    public $incrementing = false;
    protected $keyType = 'uuid';
    protected $fillable =[
        'entidad_id',
        'cedula',
        'telefono',
        'email',
        'estado'
    ];

    protected $hidden = [
        'entidad_id'
    ];

    public function entidad_comerial(): BelongsTo
    {
        return $this->belongsTo(EntidadComercial::class,'entidad_id');

    }


}
