<?php

namespace App\Providers;

// use Illuminate\Support\Facades\Gate;

use App\Models\Usuario;
use Illuminate\Auth\Access\Response;
use Illuminate\Foundation\Support\Providers\AuthServiceProvider as ServiceProvider;
use Illuminate\Support\Facades\Gate;
use Symfony\Component\HttpFoundation\JsonResponse;
use Symfony\Component\HttpFoundation\Response as HttpFoundationResponse;

class AuthServiceProvider extends ServiceProvider
{
    /**
     * The model to policy mappings for the application.
     *
     * @var array<class-string, class-string>
     */
    protected $policies = [
        // 'App\Models\Model' => 'App\Policies\ModelPolicy',
    ];

    /**
     * Register any authentication / authorization services.
     *
     * @return void
     */
    public function boot()
    {
        $this->registerPolicies();

        //USUARIOS
        Gate::define('registrar-nuevoUsuario-administrador',function(Usuario $usuario){
            $usuario->load('tipo_usuario');
            $roles=$usuario->tipo_usuario()->first();
                return(
                    ($roles->categoria ==='ADMINISTRADOR' && $roles->subcategoria==='MASTER')
                )
                ?Response::allow()
                :Response::deny('No tiene permisos para realizar esta accion.',401);
        });
        Gate::define('registrar-nuevoUsuario-mayorista',function(Usuario $usuario){
            $usuario->load('tipo_usuario');
            $roles=$usuario->tipo_usuario()->first();
                return(
                    ($roles->categoria ==='ADMINISTRADOR' && $roles->subcategoria==='MASTER') or
                    ($roles->categoria ==='MAYORISTA' && $roles->subcategoria==='MASTER')
                )
                ?Response::allow()
                :Response::deny('No tiene permisos para realizar esta accion.',401);
        });
        Gate::define('registrar-nuevoUsuario-socio',function(Usuario $usuario){
            $usuario->load('tipo_usuario');
            $roles=$usuario->tipo_usuario()->first();
                return(
                    ($roles->categoria ==='ADMINISTRADOR' && $roles->subcategoria==='MASTER') or
                    ($roles->categoria ==='SOCIO' && $roles->subcategoria==='MASTER')

                )
                ?Response::allow()
                :Response::deny('No tiene permisos para realizar esta accion.',401);
        });
        //Listar usuarios Administrador, Mayorista, Socio
        Gate::define('listar-usuarios-categorias',function(Usuario $usuario){
            $usuario->load('tipo_usuario');
            $roles=$usuario->tipo_usuario()->first();
                return(
                    ($roles->categoria ==='ADMINISTRADOR' && $roles->subcategoria==='MASTER') or
                    ($roles->categoria ==='ADMINISTRADOR' && $roles->subcategoria==='SUPERVISOR') or
                    ($roles->categoria ==='ADMINISTRADOR' && $roles->subcategoria==='FINANCIERO') or
                    ($roles->categoria ==='ADMINISTRADOR' && $roles->subcategoria==='AUDITOR')
                )
                ?Response::allow()
                :Response::deny('No tiene permisos para realizar esta accion.',401);
        });
        Gate::define('registrar-nuevoUsuario-entidad',function(Usuario $usuario){
            $usuario->load('tipo_usuario');
            $roles=$usuario->tipo_usuario()->first();
                return(
                    ($roles->categoria ==='SOCIO' && $roles->subcategoria==='MASTER') or
                    ($roles->categoria ==='SOCIO' && $roles->subcategoria==='SUPERVISOR')
                )
                ?Response::allow()
                :Response::deny('No tiene permisos para realizar esta accion.',401);
        });
        Gate::define('actualizar-usuario',function(Usuario $usuario){
            $usuario->load('tipo_usuario');
            $roles=$usuario->tipo_usuario()->first();
                return(
                    ($roles->categoria ==='ADMINISTRADOR' && $roles->subcategoria==='MASTER') or
                    ($roles->categoria ==='ADMINISTRADOR' && $roles->subcategoria==='SUPERVISOR')

                )
                ?Response::allow()
                :Response::deny('No tiene permisos para realizar esta accion.',401);
        });
        Gate::define('actualizar-usuario-entidad',function(Usuario $usuario){
            $usuario->load('tipo_usuario');
            $roles=$usuario->tipo_usuario()->first();
                return(
                    ($roles->categoria ==='SOCIO' && $roles->subcategoria==='MASTER') or
                    ($roles->categoria ==='SOCIO' && $roles->subcategoria==='SUPERVISOR')
                )
                ?Response::allow()
                :Response::deny('No tiene permisos para realizar esta accion.',401);
        });
        Gate::define('buscar-usuario',function(Usuario $usuario){
            $usuario->load('tipo_usuario');
            $roles=$usuario->tipo_usuario()->first();
                return(
                    ($roles->categoria ==='ADMINISTRADOR' && $roles->subcategoria==='MASTER') or
                    ($roles->categoria ==='ADMINISTRADOR' && $roles->subcategoria==='SUPERVISOR') or
                    ($roles->categoria ==='ADMINISTRADOR' && $roles->subcategoria==='FINANCIERO') or
                    ($roles->categoria ==='ADMINISTRADOR' && $roles->subcategoria==='AUDITOR')
                )
                ?Response::allow()
                :Response::deny('No tiene permisos para realizar esta accion.',401);
        });
        Gate::define('buscar-usuario-entidad',function(Usuario $usuario){
            $usuario->load('tipo_usuario');
            $roles=$usuario->tipo_usuario()->first();
                return(
                    ($roles->categoria ==='SOCIO' && $roles->subcategoria==='MASTER') or
                    ($roles->categoria ==='SOCIO' && $roles->subcategoria==='SUPERVISOR') or
                    ($roles->categoria ==='SOCIO' && $roles->subcategoria==='FINANCIERO') or
                    ($roles->categoria ==='SOCIO' && $roles->subcategoria==='AUDITOR')
                )
                ?Response::allow()
                :Response::deny('No tiene permisos para realizar esta accion.',401);
        });

        //ENTIDADES COMERCIALES
        Gate::define('registrar-entidadesComerciales',function(Usuario $usuario){
            $usuario->load('tipo_usuario');
            $roles=$usuario->tipo_usuario()->first();
                return(
                    ($roles->categoria ==='ADMINISTRADOR' && $roles->subcategoria==='MASTER') or
                    ($roles->categoria ==='ADMINISTRADOR' && $roles->subcategoria==='SUPERVISOR')

                )
                ?Response::allow()
                :Response::deny('No tiene permisos para realizar esta accion.',401);
        });
        Gate::define('listar-entidadesComerciales',function(Usuario $usuario){
            $usuario->load('tipo_usuario');
            $roles=$usuario->tipo_usuario()->first();
                return(
                    ($roles->categoria ==='ADMINISTRADOR' && $roles->subcategoria==='MASTER') or
                    ($roles->categoria ==='ADMINISTRADOR' && $roles->subcategoria==='SUPERVISOR') or
                    ($roles->categoria ==='ADMINISTRADOR' && $roles->subcategoria==='FINANCIERO') or
                    ($roles->categoria ==='ADMINISTRADOR' && $roles->subcategoria==='AUDITOR') or
                    ($roles->categoria ==='ADMINISTRADOR' && $roles->subcategoria==='EMISOR')

                )
                ?Response::allow()
                :Response::deny('No tiene permisos para realizar esta accion.',401);
        });
        Gate::define('actualizar-entidadesComerciales',function(Usuario $usuario){
            $usuario->load('tipo_usuario');
            $roles=$usuario->tipo_usuario()->first();
                return(
                    ($roles->categoria ==='ADMINISTRADOR' && $roles->subcategoria==='MASTER') or
                    ($roles->categoria ==='ADMINISTRADOR' && $roles->subcategoria==='SUPERVISOR')

                )
                ?Response::allow()
                :Response::deny('No tiene permisos para realizar esta accion.',401);
        });
        Gate::define('eliminar-entidadesComerciales',function(Usuario $usuario){
            $usuario->load('tipo_usuario');
            $roles=$usuario->tipo_usuario()->first();
                return(
                    ($roles->categoria ==='ADMINISTRADOR' && $roles->subcategoria==='MASTER') or
                    ($roles->categoria ==='ADMINISTRADOR' && $roles->subcategoria==='SUPERVISOR')

                )
                ?Response::allow()
                :Response::deny('No tiene permisos para realizar esta accion.',401);
        });
        Gate::define('actualizar-mi-entidadComercial',function(Usuario $usuario){
            $usuario->load('tipo_usuario');
            $roles=$usuario->tipo_usuario()->first();
                return(
                    ($roles->categoria ==='SOCIO' && $roles->subcategoria==='MASTER') or
                    ($roles->categoria ==='SOCIO' && $roles->subcategoria==='SUPERVISOR')
                )
                ?Response::allow()
                :Response::deny('No tiene permisos para realizar esta accion.',401);
        });
        Gate::define('buscar-entidad-ruc',function(Usuario $usuario){
            $usuario->load('tipo_usuario');
            $roles=$usuario->tipo_usuario()->first();
                return(
                    ($roles->categoria ==='ADMINISTRADOR' && $roles->subcategoria==='MASTER') or
                    ($roles->categoria ==='ADMINISTRADOR' && $roles->subcategoria==='SUPERVISOR') or
                    ($roles->categoria ==='ADMINISTRADOR' && $roles->subcategoria==='FINANCIERO') or
                    ($roles->categoria ==='ADMINISTRADOR' && $roles->subcategoria==='AUDITOR')

                )
                ?Response::allow()
                :Response::deny('No tiene permisos para realizar esta accion.',401);
        });
        Gate::define('ver-entidadesComerciales',function(Usuario $usuario){
            $usuario->load('tipo_usuario');
            $roles=$usuario->tipo_usuario()->first();
                return(
                    ($roles->categoria ==='ADMINISTRADOR' && $roles->subcategoria==='MASTER') or
                    ($roles->categoria ==='ADMINISTRADOR' && $roles->subcategoria==='SUPERVISOR') or
                    ($roles->categoria ==='ADMINISTRADOR' && $roles->subcategoria==='FINANCIERO') or
                    ($roles->categoria ==='ADMINISTRADOR' && $roles->subcategoria==='AUDITOR') or
                    ($roles->categoria ==='ADMINISTRADOR' && $roles->subcategoria==='EMISOR')

                )
                ?Response::allow()
                :Response::deny('No tiene permisos para realizar esta accion.',401);
        });
        Gate::define('ver-miperfil-entidadComercial',function(Usuario $usuario){
            $usuario->load('tipo_usuario');
            $roles=$usuario->tipo_usuario()->first();
                return(
                    ($roles->categoria ==='ADMINISTRADOR' && $roles->subcategoria==='MASTER')

                )
                ?Response::allow()
                :Response::deny('No tiene permisos para realizar esta accion.',401);
        });

        //ACCESOS
        Gate::define('listar-accesos',function(Usuario $usuario){
            $usuario->load('tipo_usuario');
            $roles=$usuario->tipo_usuario()->first();
                return(
                    ($roles->categoria ==='ADMINISTRADOR' && $roles->subcategoria==='MASTER') or
                    ($roles->categoria ==='ADMINISTRADOR' && $roles->subcategoria==='SUPERVISOR') or
                    ($roles->categoria ==='ADMINISTRADOR' && $roles->subcategoria==='FINANCIERO') or
                    ($roles->categoria ==='ADMINISTRADOR' && $roles->subcategoria==='AUDITOR')

                )
                ?Response::allow()
                :Response::deny('No tiene permisos para realizar esta accion.',401);
        });
        Gate::define('listar-accesos-entidad',function(Usuario $usuario){
            $usuario->load('tipo_usuario');
            $roles=$usuario->tipo_usuario()->first();
                return(
                    ($roles->categoria ==='SOCIO' && $roles->subcategoria==='MASTER') or
                    ($roles->categoria ==='SOCIO' && $roles->subcategoria==='SUPERVISOR') or
                    ($roles->categoria ==='SOCIO' && $roles->subcategoria==='FINANCIERO') or
                    ($roles->categoria ==='SOCIO' && $roles->subcategoria==='AUDITOR')

                )
                ?Response::allow()
                :Response::deny('No tiene permisos para realizar esta accion.',401);
        });
        Gate::define('listar-accesos-usuario',function(Usuario $usuario){
            $usuario->load('tipo_usuario');
            $roles=$usuario->tipo_usuario()->first();
                return(
                    ($roles->categoria ==='ADMINISTRADOR' && $roles->subcategoria==='MASTER') or
                    ($roles->categoria ==='ADMINISTRADOR' && $roles->subcategoria==='SUPERVISOR') or
                    ($roles->categoria ==='ADMINISTRADOR' && $roles->subcategoria==='FINANCIERO') or
                    ($roles->categoria ==='ADMINISTRADOR' && $roles->subcategoria==='AUDITOR') or
                    ($roles->categoria ==='ADMINISTRADOR' && $roles->subcategoria==='EMISOR')

                )
                ?Response::allow()
                :Response::deny('No tiene permisos para realizar esta accion.',401);
        });
        Gate::define('listar-accesos-usuario-entidad',function(Usuario $usuario){
            $usuario->load('tipo_usuario');
            $roles=$usuario->tipo_usuario()->first();
                return(
                    ($roles->categoria ==='SOCIO' && $roles->subcategoria==='MASTER') or
                    ($roles->categoria ==='SOCIO' && $roles->subcategoria==='SUPERVISOR') or
                    ($roles->categoria ==='SOCIO' && $roles->subcategoria==='FINANCIERO') or
                    ($roles->categoria ==='SOCIO' && $roles->subcategoria==='AUDITOR')

                )
                ?Response::allow()
                :Response::deny('No tiene permisos para realizar esta accion.',401);
        });



        //SOLICITUDES FIRMA
        Gate::define('registrar-solicitud',function(Usuario $usuario){
            $usuario->load('tipo_usuario');
            $roles=$usuario->tipo_usuario()->first();
                return(
                    ($roles->categoria ==='SOCIO' && $roles->subcategoria==='MASTER') or
                    ($roles->categoria ==='SOCIO' && $roles->subcategoria==='SUPERVISOR') or
                    ($roles->categoria ==='SOCIO' && $roles->subcategoria==='EMISOR')

                )
                ?Response::allow()
                :Response::deny('No tiene permisos para realizar esta accion.',401);
        });
        Gate::define('listar-solicitudes',function(Usuario $usuario){
            $usuario->load('tipo_usuario');
            $roles=$usuario->tipo_usuario()->first();
                return(
                    ($roles->categoria ==='ADMINISTRADOR' && $roles->subcategoria==='MASTER') or
                    ($roles->categoria ==='ADMINISTRADOR' && $roles->subcategoria==='SUPERVISOR') or
                    ($roles->categoria ==='ADMINISTRADOR' && $roles->subcategoria==='FINANCIERO') or
                    ($roles->categoria ==='ADMINISTRADOR' && $roles->subcategoria==='AUDITOR')

                )
                ?Response::allow()
                :Response::deny('No tiene permisos para realizar esta accion.',401);
        });
        Gate::define('listar-solicitudes-entidad',function(Usuario $usuario){
            $usuario->load('tipo_usuario');
            $roles=$usuario->tipo_usuario()->first();
                return(
                    ($roles->categoria ==='SOCIO' && $roles->subcategoria==='MASTER') or
                    ($roles->categoria ==='SOCIO' && $roles->subcategoria==='SUPERVISOR') or
                    ($roles->categoria ==='SOCIO' && $roles->subcategoria==='FINANCIERO') or
                    ($roles->categoria ==='SOCIO' && $roles->subcategoria==='AUDITOR')

                )
                ?Response::allow()
                :Response::deny('No tiene permisos para realizar esta accion.',401);
        });
        Gate::define('listar-solicitudes-usuario',function(Usuario $usuario){
            $usuario->load('tipo_usuario');
            $roles=$usuario->tipo_usuario()->first();
                return(
                    ($roles->categoria ==='SOCIO' && $roles->subcategoria==='MASTER') or
                    ($roles->categoria ==='SOCIO' && $roles->subcategoria==='SUPERVISOR') or
                    ($roles->categoria ==='SOCIO' && $roles->subcategoria==='EMISOR')
                )
                ?Response::allow()
                :Response::deny('No tiene permisos para realizar esta accion.',401);
        });
        Gate::define('listar-solicitudes-nuevas',function(Usuario $usuario){
            $usuario->load('tipo_usuario');
            $roles=$usuario->tipo_usuario()->first();
                return(
                    ($roles->categoria ==='ADMINISTRADOR' && $roles->subcategoria==='MASTER') or
                    ($roles->categoria ==='ADMINISTRADOR' && $roles->subcategoria==='SUPERVISOR') or
                    ($roles->categoria ==='ADMINISTRADOR' && $roles->subcategoria==='FINANCIERO') or
                    ($roles->categoria ==='ADMINISTRADOR' && $roles->subcategoria==='AUDITOR') or
                    ($roles->categoria ==='ADMINISTRADOR' && $roles->subcategoria==='EMISOR')

                )
                ?Response::allow()
                :Response::deny('No tiene permisos para realizar esta accion.',401);
        });
        Gate::define('listar-solicitudes-nuevas-entidad',function(Usuario $usuario){
            $usuario->load('tipo_usuario');
            $roles=$usuario->tipo_usuario()->first();
                return(
                    ($roles->categoria ==='SOCIO' && $roles->subcategoria==='MASTER') or
                    ($roles->categoria ==='SOCIO' && $roles->subcategoria==='SUPERVISOR') or
                    ($roles->categoria ==='SOCIO' && $roles->subcategoria==='FINANCIERO') or
                    ($roles->categoria ==='SOCIO' && $roles->subcategoria==='AUDITOR')

                )
                ?Response::allow()
                :Response::deny('No tiene permisos para realizar esta accion.',401);
        });
        Gate::define('buscar-solicitudes',function(Usuario $usuario){
            $usuario->load('tipo_usuario');
            $roles=$usuario->tipo_usuario()->first();
                return(
                    ($roles->categoria ==='ADMINISTRADOR' && $roles->subcategoria==='MASTER') or
                    ($roles->categoria ==='ADMINISTRADOR' && $roles->subcategoria==='SUPERVISOR') or
                    ($roles->categoria ==='ADMINISTRADOR' && $roles->subcategoria==='FINANCIERO') or
                    ($roles->categoria ==='ADMINISTRADOR' && $roles->subcategoria==='AUDITOR')

                )
                ?Response::allow()
                :Response::deny('No tiene permisos para realizar esta accion.',401);
        });
        Gate::define('buscar-solicitudes-entidad',function(Usuario $usuario){
            $usuario->load('tipo_usuario');
            $roles=$usuario->tipo_usuario()->first();
                return(
                    ($roles->categoria ==='SOCIO' && $roles->subcategoria==='MASTER') or
                    ($roles->categoria ==='SOCIO' && $roles->subcategoria==='SUPERVISOR') or
                    ($roles->categoria ==='SOCIO' && $roles->subcategoria==='FINANCIERO') or
                    ($roles->categoria ==='SOCIO' && $roles->subcategoria==='AUDITOR')

                )
                ?Response::allow()
                :Response::deny('No tiene permisos para realizar esta accion.',401);
        });
        Gate::define('buscar-solicitudes-usuario',function(Usuario $usuario){
            $usuario->load('tipo_usuario');
            $roles=$usuario->tipo_usuario()->first();
                return(

                    ($roles->categoria ==='ADMINISTRADOR' && $roles->subcategoria==='EMISOR') or
                    ($roles->categoria ==='SOCIO' && $roles->subcategoria==='EMISOR')

                )
                ?Response::allow()
                :Response::deny('No tiene permisos para realizar esta accion.',401);
        });
        Gate::define('actualizar-solicitud',function(Usuario $usuario){
            $usuario->load('tipo_usuario');
            $roles=$usuario->tipo_usuario()->first();
                return(
                    ($roles->categoria ==='ADMINISTRADOR' && $roles->subcategoria==='MASTER') or
                    ($roles->categoria ==='ADMINISTRADOR' && $roles->subcategoria==='SUPERVISOR')

                )
                ?Response::allow()
                :Response::deny('No tiene permisos para realizar esta accion.',401);
        });
        Gate::define('actualizar-solicitud-entidad',function(Usuario $usuario){
            $usuario->load('tipo_usuario');
            $roles=$usuario->tipo_usuario()->first();
                return(
                    ($roles->categoria ==='SOCIO' && $roles->subcategoria==='MASTER') or
                    ($roles->categoria ==='SOCIO' && $roles->subcategoria==='SUPERVISOR')

                )
                ?Response::allow()
                :Response::deny('No tiene permisos para realizar esta accion.',401);
        });
        Gate::define('actualizar-solicitud-usuario',function(Usuario $usuario){
            $usuario->load('tipo_usuario');
            $roles=$usuario->tipo_usuario()->first();
                return(
                    ($roles->categoria ==='SOCIO' && $roles->subcategoria==='MASTER') or
                    ($roles->categoria ==='SOCIO' && $roles->subcategoria==='SUPERVISOR') or
                    ($roles->categoria ==='SOCIO' && $roles->subcategoria==='EMISOR')

                )
                ?Response::allow()
                :Response::deny('No tiene permisos para realizar esta accion.',401);
        });

        Gate::define('actualizar-micontacto-entidadComercial',function(Usuario $usuario){
            $usuario->load('tipo_usuario');
            $roles=$usuario->tipo_usuario()->first();
                return(
                    ($roles->categoria ==='ADMINISTRADOR' &&
                    $roles->subcategoria==='MASTER')

                )
                ?Response::allow()
                :Response::deny('No tiene permisos para realizar esta accion.',401);
        });
        Gate::define('actualizar-miinterfaz-entidadComercial',function(Usuario $usuario){
            $usuario->load('tipo_usuario');
            $roles=$usuario->tipo_usuario()->first();
                return(
                    ($roles->categoria ==='ADMINISTRADOR' &&
                    $roles->subcategoria==='MASTER')

                )
                ?Response::allow()
                :Response::deny('No tiene permisos para realizar esta accion.',401);
        });

        //PRECIOS FIRMAS
        Gate::define('registrar-preciosFirmas',function(Usuario $usuario){
            $usuario->load('tipo_usuario');
            $roles=$usuario->tipo_usuario()->first();
                return(
                    ($roles->categoria ==='ADMINISTRADOR' && $roles->subcategoria==='MASTER')or
                    ($roles->categoria==='ADMINISTRADOR' && $roles->subcategoria==='SUPERVISOR')
                )
                ?Response::allow()
                :Response::deny('No tiene permisos para realizar esta accion.',401);
        });
        Gate::define('actualizar-preciosFirmas',function(Usuario $usuario){
            $usuario->load('tipo_usuario');
            $roles=$usuario->tipo_usuario()->first();
                return(
                    ($roles->categoria ==='ADMINISTRADOR' && $roles->subcategoria==='MASTER')or
                    ($roles->categoria==='ADMINISTRADOR' && $roles->subcategoria==='SUPERVISOR')
                )
                ?Response::allow()
                :Response::deny('No tiene permisos para realizar esta accion.',401);
        });
        Gate::define('actualizar-pvp-preciosFirmas',function(Usuario $usuario){
            $usuario->load('tipo_usuario');
            $roles=$usuario->tipo_usuario()->first();
                return(
                    ($roles->categoria ==='SOCIO' && $roles->subcategoria==='MASTER')or
                    ($roles->categoria==='SOCIO' && $roles->subcategoria==='SUPERVISOR')
                )
                ?Response::allow()
                :Response::deny('No tiene permisos para realizar esta accion.',401);
        });

        //SOLICITUDES DE FIRMAS
        Gate::define('listar-solicitud-firma-administrador',function(Usuario $usuario){
            $usuario->load('tipo_usuario');
            $roles=$usuario->tipo_usuario()->first();
                return(
                    ($roles->categoria ==='ADMINISTRADOR' && $roles->subcategoria==='MASTER')or
                    ($roles->categoria==='ADMINISTRADOR' && $roles->subcategoria==='SUPERVISOR')or
                    ($roles->categoria==='ADMINISTRADOR' && $roles->subcategoria==='FINANCIERO')or
                    ($roles->categoria==='ADMINISTRADOR' && $roles->subcategoria==='AUDITOR')
                )
                ?Response::allow()
                :Response::deny('No tiene permisos para realizar esta accion.',401);
        });
        Gate::define('listar-solicitud-firma-socio',function(Usuario $usuario){
            $usuario->load('tipo_usuario');
            $roles=$usuario->tipo_usuario()->first();
                return(
                    ($roles->categoria ==='SOCIO' && $roles->subcategoria==='MASTER')or
                    ($roles->categoria==='SOCIO' && $roles->subcategoria==='SUPERVISOR')or
                    ($roles->categoria==='SOCIO' && $roles->subcategoria==='FINANCIERO')or
                    ($roles->categoria==='SOCIO' && $roles->subcategoria==='AUDITOR')
                )
                ?Response::allow()
                :Response::deny('No tiene permisos para realizar esta accion.',401);
        });
        Gate::define('listar-solicitud-firma-solicita',function(Usuario $usuario){
            $usuario->load('tipo_usuario');
            $roles=$usuario->tipo_usuario()->first();
                return(
                    ($roles->categoria ==='SOCIO' && $roles->subcategoria==='MASTER')or
                    ($roles->categoria==='SOCIO' && $roles->subcategoria==='SUPERVISOR')or
                    ($roles->categoria==='SOCIO' && $roles->subcategoria==='EMISOR')
                )
                ?Response::allow()
                :Response::deny('No tiene permisos para realizar esta accion.',401);
        });

        //FIRMA REPRESENTANTE LEGAL
        Gate::define('registrar-firma-representante',function(Usuario $usuario){
            $usuario->load('tipo_usuario');
            $roles=$usuario->tipo_usuario()->first();
                return(
                    ($roles->categoria ==='SOCIO' && $roles->subcategoria==='MASTER')or
                    ($roles->categoria==='SOCIO' && $roles->subcategoria==='SUPERVISOR')or
                    ($roles->categoria==='SOCIO' && $roles->subcategoria==='AUDITOR')
                )
                ?Response::allow()
                :Response::deny('No tiene permisos para realizar esta accion.',401);
        });
        Gate::define('listar-firmas-representante',function(Usuario $usuario){
            $usuario->load('tipo_usuario');
            $roles=$usuario->tipo_usuario()->first();
                return(
                    ($roles->categoria ==='ADMINISTRADOR' && $roles->subcategoria==='MASTER')or
                    ($roles->categoria==='ADMINISTRADOR' && $roles->subcategoria==='SUPERVISOR')or
                    ($roles->categoria==='ADMINISTRADOR' && $roles->subcategoria==='FINANCIERO')or
                    ($roles->categoria==='ADMINISTRADOR' && $roles->subcategoria==='AUDITOR')
                )
                ?Response::allow()
                :Response::deny('No tiene permisos para realizar esta accion.',401);
        });
        Gate::define('listar-firmas-representante-entidad',function(Usuario $usuario){
            $usuario->load('tipo_usuario');
            $roles=$usuario->tipo_usuario()->first();
                return(
                    ($roles->categoria ==='SOCIO' && $roles->subcategoria==='MASTER')or
                    ($roles->categoria==='SOCIO' && $roles->subcategoria==='SUPERVISOR')or
                    ($roles->categoria==='SOCIO' && $roles->subcategoria==='FINANCIERO')or
                    ($roles->categoria==='SOCIO' && $roles->subcategoria==='AUDITOR')
                )
                ?Response::allow()
                :Response::deny('No tiene permisos para realizar esta accion.',401);
        });
        Gate::define('listar-firmas-representante-usuario',function(Usuario $usuario){
            $usuario->load('tipo_usuario');
            $roles=$usuario->tipo_usuario()->first();
                return(
                    ($roles->categoria ==='SOCIO' && $roles->subcategoria==='MASTER')or
                    ($roles->categoria==='SOCIO' && $roles->subcategoria==='SUPERVISOR')or
                    ($roles->categoria==='SOCIO' && $roles->subcategoria==='EMISOR')
                )
                ?Response::allow()
                :Response::deny('No tiene permisos para realizar esta accion.',401);
        });
        Gate::define('actualizar-firma-representante',function(Usuario $usuario){
            $usuario->load('tipo_usuario');
            $roles=$usuario->tipo_usuario()->first();
                return(
                    ($roles->categoria ==='ADMINISTRADOR' && $roles->subcategoria==='MASTER')or
                    ($roles->categoria==='ADMINISTRADOR' && $roles->subcategoria==='SUPERVISOR')

                )
                ?Response::allow()
                :Response::deny('No tiene permisos para realizar esta accion.',401);
        });
        Gate::define('actualizar-firma-representante-entidad',function(Usuario $usuario){
            $usuario->load('tipo_usuario');
            $roles=$usuario->tipo_usuario()->first();
                return(
                    ($roles->categoria ==='SOCIO' && $roles->subcategoria==='MASTER')or
                    ($roles->categoria==='SOCIO' && $roles->subcategoria==='SUPERVISOR')
                )
                ?Response::allow()
                :Response::deny('No tiene permisos para realizar esta accion.',401);
        });
        Gate::define('actualizar-firma-representante-usuario',function(Usuario $usuario){
            $usuario->load('tipo_usuario');
            $roles=$usuario->tipo_usuario()->first();
                return(
                    ($roles->categoria ==='SOCIO' && $roles->subcategoria==='MASTER')or
                    ($roles->categoria==='SOCIO' && $roles->subcategoria==='SUPERVISOR') or
                    ($roles->categoria==='SOCIO' && $roles->subcategoria==='EMISOR')
                )
                ?Response::allow()
                :Response::deny('No tiene permisos para realizar esta accion.',401);
        });

        //FIRMA JURIDICA
        Gate::define('registrar-firma-juridica',function(Usuario $usuario){
            $usuario->load('tipo_usuario');
            $roles=$usuario->tipo_usuario()->first();
                return(
                    ($roles->categoria ==='SOCIO' && $roles->subcategoria==='MASTER')or
                    ($roles->categoria==='SOCIO' && $roles->subcategoria==='SUPERVISOR')or
                    ($roles->categoria==='SOCIO' && $roles->subcategoria==='AUDITOR')
                )
                ?Response::allow()
                :Response::deny('No tiene permisos para realizar esta accion.',401);
        });
        Gate::define('listar-firmas-juridica',function(Usuario $usuario){
            $usuario->load('tipo_usuario');
            $roles=$usuario->tipo_usuario()->first();
                return(
                    ($roles->categoria ==='ADMINISTRADOR' && $roles->subcategoria==='MASTER')or
                    ($roles->categoria==='ADMINISTRADOR' && $roles->subcategoria==='SUPERVISOR')or
                    ($roles->categoria==='ADMINISTRADOR' && $roles->subcategoria==='FINANCIERO')or
                    ($roles->categoria==='ADMINISTRADOR' && $roles->subcategoria==='AUDITOR')
                )
                ?Response::allow()
                :Response::deny('No tiene permisos para realizar esta accion.',401);
        });
        Gate::define('listar-firmas-juridica-entidad',function(Usuario $usuario){
            $usuario->load('tipo_usuario');
            $roles=$usuario->tipo_usuario()->first();
                return(
                    ($roles->categoria ==='SOCIO' && $roles->subcategoria==='MASTER')or
                    ($roles->categoria==='SOCIO' && $roles->subcategoria==='SUPERVISOR')or
                    ($roles->categoria==='SOCIO' && $roles->subcategoria==='FINANCIERO')or
                    ($roles->categoria==='SOCIO' && $roles->subcategoria==='AUDITOR')
                )
                ?Response::allow()
                :Response::deny('No tiene permisos para realizar esta accion.',401);
        });
        Gate::define('listar-firmas-juridica-usuario',function(Usuario $usuario){
            $usuario->load('tipo_usuario');
            $roles=$usuario->tipo_usuario()->first();
                return(
                    ($roles->categoria ==='SOCIO' && $roles->subcategoria==='MASTER')or
                    ($roles->categoria==='SOCIO' && $roles->subcategoria==='SUPERVISOR')or
                    ($roles->categoria==='SOCIO' && $roles->subcategoria==='EMISOR')
                )
                ?Response::allow()
                :Response::deny('No tiene permisos para realizar esta accion.',401);
        });
        Gate::define('actualizar-firma-juridica',function(Usuario $usuario){
            $usuario->load('tipo_usuario');
            $roles=$usuario->tipo_usuario()->first();
                return(
                    ($roles->categoria ==='ADMINISTRADOR' && $roles->subcategoria==='MASTER')or
                    ($roles->categoria==='ADMINISTRADOR' && $roles->subcategoria==='SUPERVISOR')

                )
                ?Response::allow()
                :Response::deny('No tiene permisos para realizar esta accion.',401);
        });
        Gate::define('actualizar-firma-juridica-entidad',function(Usuario $usuario){
            $usuario->load('tipo_usuario');
            $roles=$usuario->tipo_usuario()->first();
                return(
                    ($roles->categoria ==='SOCIO' && $roles->subcategoria==='MASTER')or
                    ($roles->categoria==='SOCIO' && $roles->subcategoria==='SUPERVISOR')
                )
                ?Response::allow()
                :Response::deny('No tiene permisos para realizar esta accion.',401);
        });
        Gate::define('actualizar-firma-juridica-usuario',function(Usuario $usuario){
            $usuario->load('tipo_usuario');
            $roles=$usuario->tipo_usuario()->first();
                return(
                    ($roles->categoria ==='SOCIO' && $roles->subcategoria==='MASTER')or
                    ($roles->categoria==='SOCIO' && $roles->subcategoria==='SUPERVISOR') or
                    ($roles->categoria==='SOCIO' && $roles->subcategoria==='EMISOR')
                )
                ?Response::allow()
                :Response::deny('No tiene permisos para realizar esta accion.',401);
        });

         //FIRMA EMPRESARIAL
         Gate::define('registrar-firma-empresarial',function(Usuario $usuario){
            $usuario->load('tipo_usuario');
            $roles=$usuario->tipo_usuario()->first();
                return(
                    ($roles->categoria ==='SOCIO' && $roles->subcategoria==='MASTER')or
                    ($roles->categoria==='SOCIO' && $roles->subcategoria==='SUPERVISOR')or
                    ($roles->categoria==='SOCIO' && $roles->subcategoria==='AUDITOR')
                )
                ?Response::allow()
                :Response::deny('No tiene permisos para realizar esta accion.',401);
        });
        Gate::define('listar-firmas-empresarial',function(Usuario $usuario){
            $usuario->load('tipo_usuario');
            $roles=$usuario->tipo_usuario()->first();
                return(
                    ($roles->categoria ==='ADMINISTRADOR' && $roles->subcategoria==='MASTER')or
                    ($roles->categoria==='ADMINISTRADOR' && $roles->subcategoria==='SUPERVISOR')or
                    ($roles->categoria==='ADMINISTRADOR' && $roles->subcategoria==='FINANCIERO')or
                    ($roles->categoria==='ADMINISTRADOR' && $roles->subcategoria==='AUDITOR')
                )
                ?Response::allow()
                :Response::deny('No tiene permisos para realizar esta accion.',401);
        });
        Gate::define('listar-firmas-empresarial-entidad',function(Usuario $usuario){
            $usuario->load('tipo_usuario');
            $roles=$usuario->tipo_usuario()->first();
                return(
                    ($roles->categoria ==='SOCIO' && $roles->subcategoria==='MASTER')or
                    ($roles->categoria==='SOCIO' && $roles->subcategoria==='SUPERVISOR')or
                    ($roles->categoria==='SOCIO' && $roles->subcategoria==='FINANCIERO')or
                    ($roles->categoria==='SOCIO' && $roles->subcategoria==='AUDITOR')
                )
                ?Response::allow()
                :Response::deny('No tiene permisos para realizar esta accion.',401);
        });
        Gate::define('listar-firmas-empresarial-usuario',function(Usuario $usuario){
            $usuario->load('tipo_usuario');
            $roles=$usuario->tipo_usuario()->first();
                return(
                    ($roles->categoria ==='SOCIO' && $roles->subcategoria==='MASTER')or
                    ($roles->categoria==='SOCIO' && $roles->subcategoria==='SUPERVISOR')or
                    ($roles->categoria==='SOCIO' && $roles->subcategoria==='EMISOR')
                )
                ?Response::allow()
                :Response::deny('No tiene permisos para realizar esta accion.',401);
        });
        Gate::define('actualizar-firma-empresarial',function(Usuario $usuario){
            $usuario->load('tipo_usuario');
            $roles=$usuario->tipo_usuario()->first();
                return(
                    ($roles->categoria ==='ADMINISTRADOR' && $roles->subcategoria==='MASTER')or
                    ($roles->categoria==='ADMINISTRADOR' && $roles->subcategoria==='SUPERVISOR')

                )
                ?Response::allow()
                :Response::deny('No tiene permisos para realizar esta accion.',401);
        });
        Gate::define('actualizar-firma-empresarial-entidad',function(Usuario $usuario){
            $usuario->load('tipo_usuario');
            $roles=$usuario->tipo_usuario()->first();
                return(
                    ($roles->categoria ==='SOCIO' && $roles->subcategoria==='MASTER')or
                    ($roles->categoria==='SOCIO' && $roles->subcategoria==='SUPERVISOR')
                )
                ?Response::allow()
                :Response::deny('No tiene permisos para realizar esta accion.',401);
        });
        Gate::define('actualizar-firma-empresarial-usuario',function(Usuario $usuario){
            $usuario->load('tipo_usuario');
            $roles=$usuario->tipo_usuario()->first();
                return(
                    ($roles->categoria ==='SOCIO' && $roles->subcategoria==='MASTER')or
                    ($roles->categoria==='SOCIO' && $roles->subcategoria==='SUPERVISOR') or
                    ($roles->categoria==='SOCIO' && $roles->subcategoria==='EMISOR')
                )
                ?Response::allow()
                :Response::deny('No tiene permisos para realizar esta accion.',401);
        });

        //ESTADO SOLICITUD
        Gate::define('actualizar-estadoSolicitud',function(Usuario $usuario){
            $usuario->load('tipo_usuario');
            $roles=$usuario->tipo_usuario()->first();
                return(
                    ($roles->categoria ==='ADMINISTRADOR' && $roles->subcategoria==='MASTER')or
                    ($roles->categoria==='ADMINISTRADOR' && $roles->subcategoria==='SUPERVISOR')
                )
                ?Response::allow()
                :Response::deny('No tiene permisos para realizar esta accion.',401);
        });
        Gate::define('actualizar-estadoSolicitud-entidad',function(Usuario $usuario){
            $usuario->load('tipo_usuario');
            $roles=$usuario->tipo_usuario()->first();
                return(
                    ($roles->categoria ==='SOCIO' && $roles->subcategoria==='MASTER')or
                    ($roles->categoria==='SOCIO' && $roles->subcategoria==='SUPERVISOR')
                )
                ?Response::allow()
                :Response::deny('No tiene permisos para realizar esta accion.',401);
        });

        //API COORPORATIVO
        Gate::define('listar-api-coorporativo',function(Usuario $usuario){
            $usuario->load('tipo_usuario');
            $roles=$usuario->tipo_usuario()->first();
                return(
                    ($roles->categoria ==='ADMINISTRADOR' && $roles->subcategoria==='MASTER')or
                    ($roles->categoria==='ADMINISTRADOR' && $roles->subcategoria==='SUPERVISOR')or
                    ($roles->categoria==='ADMINISTRADOR' && $roles->subcategoria==='FINANCIERO')or
                    ($roles->categoria==='ADMINISTRADOR' && $roles->subcategoria==='AUDITOR')
                )
                ?Response::allow()
                :Response::deny('No tiene permisos para realizar esta accion.',401);
        });
        Gate::define('registrar-api-coorporativo',function(Usuario $usuario){
            $usuario->load('tipo_usuario');
            $roles=$usuario->tipo_usuario()->first();
                return(
                    ($roles->categoria ==='ADMINISTRADOR' && $roles->subcategoria==='MASTER')or
                    ($roles->categoria==='ADMINISTRADOR' && $roles->subcategoria==='SUPERVISOR')
                )
                ?Response::allow()
                :Response::deny('No tiene permisos para realizar esta accion.',401);
        });
        Gate::define('ver-api-coorporativo',function(Usuario $usuario){
            $usuario->load('tipo_usuario');
            $roles=$usuario->tipo_usuario()->first();
                return(
                    ($roles->categoria ==='ADMINISTRADOR' && $roles->subcategoria==='MASTER')or
                    ($roles->categoria==='ADMINISTRADOR' && $roles->subcategoria==='SUPERVISOR')
                )
                ?Response::allow()
                :Response::deny('No tiene permisos para realizar esta accion.',401);
        });
        Gate::define('ver-api-coorporativo-entidad',function(Usuario $usuario){
            $usuario->load('tipo_usuario');
            $roles=$usuario->tipo_usuario()->first();
                return(
                    ($roles->categoria ==='SOCIO' && $roles->subcategoria==='MASTER')or
                    ($roles->categoria==='SOCIO' && $roles->subcategoria==='SUPERVISOR')
                )
                ?Response::allow()
                :Response::deny('No tiene permisos para realizar esta accion.',401);
        });
        Gate::define('actualizar-api-coorporativo',function(Usuario $usuario){
            $usuario->load('tipo_usuario');
            $roles=$usuario->tipo_usuario()->first();
                return(
                    ($roles->categoria ==='ADMINISTRADOR' && $roles->subcategoria==='MASTER')or
                    ($roles->categoria==='ADMINISTRADOR' && $roles->subcategoria==='SUPERVISOR')
                )
                ?Response::allow()
                :Response::deny('No tiene permisos para realizar esta accion.',401);
        });
        Gate::define('enviar-credenciales-api-coorporativo',function(Usuario $usuario){
            $usuario->load('tipo_usuario');
            $roles=$usuario->tipo_usuario()->first();
                return(
                    ($roles->categoria ==='ADMINISTRADOR' && $roles->subcategoria==='MASTER')or
                    ($roles->categoria==='ADMINISTRADOR' && $roles->subcategoria==='SUPERVISOR')
                )
                ?Response::allow()
                :Response::deny('No tiene permisos para realizar esta accion.',401);
        });

        //REGISTRO LOTES
        Gate::define('listar-registro-lotes',function(Usuario $usuario){
            $usuario->load('tipo_usuario');
            $roles=$usuario->tipo_usuario()->first();
                return(
                    ($roles->categoria ==='ADMINISTRADOR' && $roles->subcategoria==='MASTER') or
                    ($roles->categoria==='ADMINISTRADOR' && $roles->subcategoria==='SUPERVISOR') or
                    ($roles->categoria==='ADMINISTRADOR' && $roles->subcategoria==='FINANCIERO') or
                    ($roles->categoria==='ADMINISTRADOR' && $roles->subcategoria==='AUDITOR')
                )
                ?Response::allow()
                :Response::deny('No tiene permisos para realizar esta accion.',401);
        });
        Gate::define('listar-registro-lotes-entidad',function(Usuario $usuario){
            $usuario->load('tipo_usuario');
            $roles=$usuario->tipo_usuario()->first();
                return(
                    ($roles->categoria ==='SOCIO' && $roles->subcategoria==='MASTER') or
                    ($roles->categoria==='SOCIO' && $roles->subcategoria==='SUPERVISOR') or
                    ($roles->categoria==='SOCIO' && $roles->subcategoria==='FINANCIERO') or
                    ($roles->categoria==='SOCIO' && $roles->subcategoria==='AUDITOR')
                )
                ?Response::allow()
                :Response::deny('No tiene permisos para realizar esta accion.',401);
        });
        Gate::define('listar-registro-lotes-usuario',function(Usuario $usuario){
            $usuario->load('tipo_usuario');
            $roles=$usuario->tipo_usuario()->first();
                return(
                    ($roles->categoria==='ADMINISTRADOR' && $roles->subcategoria==='EMISOR') or
                    ($roles->categoria==='SOCIO' && $roles->subcategoria==='EMISOR')
                )
                ?Response::allow()
                :Response::deny('No tiene permisos para realizar esta accion.',401);
        });

        //SOLICITUDES LOTES
        Gate::define('listar-solicitudes-lotes',function(Usuario $usuario){
            $usuario->load('tipo_usuario');
            $roles=$usuario->tipo_usuario()->first();
                return(
                    ($roles->categoria ==='ADMINISTRADOR' && $roles->subcategoria==='MASTER') or
                    ($roles->categoria==='ADMINISTRADOR' && $roles->subcategoria==='SUPERVISOR') or
                    ($roles->categoria==='ADMINISTRADOR' && $roles->subcategoria==='FINANCIERO') or
                    ($roles->categoria==='ADMINISTRADOR' && $roles->subcategoria==='AUDITOR')

                )
                ?Response::allow()
                :Response::deny('No tiene permisos para realizar esta accion.',401);
        });
        Gate::define('listar-solicitudes-lotes-entidad',function(Usuario $usuario){
            $usuario->load('tipo_usuario');
            $roles=$usuario->tipo_usuario()->first();
                return(
                    ($roles->categoria ==='SOCIO' && $roles->subcategoria==='MASTER') or
                    ($roles->categoria==='SOCIO' && $roles->subcategoria==='SUPERVISOR') or
                    ($roles->categoria==='SOCIO' && $roles->subcategoria==='FINANCIERO') or
                    ($roles->categoria==='SOCIO' && $roles->subcategoria==='AUDITOR')
                )
                ?Response::allow()
                :Response::deny('No tiene permisos para realizar esta accion.',401);
        });
        Gate::define('listar-solicitudes-lotes-usuario',function(Usuario $usuario){
            $usuario->load('tipo_usuario');
            $roles=$usuario->tipo_usuario()->first();
                return(
                    ($roles->categoria==='ADMINISTRADOR' && $roles->subcategoria==='EMISOR') or
                    ($roles->categoria==='SOCIO' && $roles->subcategoria==='EMISOR')
                )
                ?Response::allow()
                :Response::deny('No tiene permisos para realizar esta accion.',401);
        });

        //RED ACTIVA
        Gate::define('registrar-redActiva',function(Usuario $usuario){
            $usuario->load('tipo_usuario');
            $roles=$usuario->tipo_usuario()->first();
            return(
                ($roles->categoria ==='ADMINISTRADOR' && $roles->subcategoria==='MASTER') or
                ($roles->categoria ==='ADMINISTRADOR' && $roles->subcategoria==='SUPERVISOR')

            )
                ?Response::allow()
                :Response::deny('No tiene permisos para realizar esta accion.',401);
        });

        //DISPOSITIVOS KIOSKO
        Gate::define('registrar-dispositivo',function(Usuario $usuario){
            $usuario->load('tipo_usuario');
            $roles=$usuario->tipo_usuario()->first();
                return(
                    ($roles->categoria ==='ADMINISTRADOR' && $roles->subcategoria==='MASTER')
                )
                ?Response::allow()
                :Response::deny('No tiene permisos para realizar esta accion.',401);
        });

    }
}
