<?php

namespace App\Repositories;

use App\Interfaces\EstadoSolicitudInterface;
use App\Models\EstadoSolicitud;

class EstadoSolicitudRepository implements EstadoSolicitudInterface
{
    public function getAll($data)
    {
        return EstadoSolicitud::with('solicitud')->orderBy('fecha_registro','DESC')->paginate($data->query('per_page') ?? 10);
    }

    public function getById($id)
    {
        return EstadoSolicitud::with('solicitud')->find($id);
    }

    public function create(array $data )
    {
        return EstadoSolicitud::create($data);
    }

    public function update($id,array $data)
    {
        $estadoSolicitud = EstadoSolicitud::find($id);
        if($estadoSolicitud==null){
            return null;
        }
        else{
            
            $estadoSolicitud->update($data);
            return $estadoSolicitud;
        }
    }

    public function delete($id)
    {
        $estadoSolicitud = EstadoSolicitud::find($id);
        $estadoSolicitud->delete();
        return $estadoSolicitud;
    }

    public function updateEstadoEntidad($id,array $data)
    {
        $estadoSolicitud = EstadoSolicitud::with('solicitud')->where('id',$id)->whereHas('solicitud',function ($query) {
            $query->where('entidad_solicitante',auth()->user()->entidad_id);
        })->first();
        if($estadoSolicitud==null){
            return null;
        }
        else{
            $estadoSolicitud->update($data);
            return $estadoSolicitud;
        }
    }
}