<?php
namespace App\Repositories;

use App\Interfaces\FirmaInterface;
use App\Models\FirmaJuridica;
use App\Models\FirmaRepresentanteLegal;

class FirmaRepresentanteLegalRepository implements FirmaInterface
{
    public function getAll($data){
        return FirmaRepresentanteLegal::with('solicitud')->paginate($data->query('per_page') ?? 10);
        
    }
    public function getById($firmaId){
        return FirmaRepresentanteLegal::with('solicitud')->where('id',$firmaId)->first();
    }
    public function delete($firmaId){

    }
    public function create(array $firmaDetails){
        return FirmaRepresentanteLegal::create($firmaDetails);
    }
    public function update($firmaId, array $firmaDetails){
        $solicitud=FirmaRepresentanteLegal::with('solicitud')->where('id',$firmaId)->first();
        if ($solicitud == null) {
            return null;
        } else {
            $solicitud->update($firmaDetails);
            $solicitud->solicitud->update($firmaDetails);
            return $solicitud;
        }
    }

    public function getFirmasEntidad($data)
    {
        $solicitudes=FirmaRepresentanteLegal::with('solicitud')->
        whereHas('solicitud',function($q){
            $q->where('entidad_solicitante',auth()->user()->entidad_id);
        })->paginate($data->query('per_page') ?? 10);
        return $solicitudes;
    }

    public function getFirmasUsuario($data)
    {
        $solicitudes=FirmaRepresentanteLegal::with('solicitud')->
        whereHas('solicitud',function($q){
            $q->where('usuario_solicita',auth()->user()->id);
        })->paginate($data->query('per_page') ?? 10);
        return $solicitudes;
    }

    public function updateFirmaEntidad($firmaId, array $firmaDetails)
    {
        $solicitud = FirmaRepresentanteLegal::with('solicitud')->whereHas('solicitud', function ($q) {
            $q->where('entidad_solicitante', auth()->user()->entidad_id);
        })->where('id', $firmaId)->first();
        if ($solicitud == null) {
            return null;
        } else {
            $solicitud->update($firmaDetails);
            $solicitud->solicitud->update($firmaDetails);
            return $solicitud;
        }
    }

    public function updateFirmaUsuario($firmaId, array $firmaDetails)
    {
        $solicitud = FirmaRepresentanteLegal::with('solicitud')->whereHas('solicitud', function ($q) {
            $q->where('usuario_solicita', auth()->user()->id);
        })->where('id', $firmaId)->first();
        if ($solicitud == null) {
            return null;
        } else {
            $solicitud->update($firmaDetails);
            $solicitud->solicitud->update($firmaDetails);
            return $solicitud;
        }
    }


}