<?php

namespace App\Repositories;

use App\Interfaces\SolicitudFirmaInterface;
use App\Models\EntidadComercial;
use App\Models\SolicitudFirma;
use Carbon\Carbon;

class SolicitudFirmaRepository implements SolicitudFirmaInterface
{
    public function getAll($data)
    {
        return SolicitudFirma::with('firmaRL', 'firmaEmpresarial', 'firmaJuridica', 'estado')->paginate($data->query('per_page') ?? 10);
    }
    public function getById($id)
    {
        return SolicitudFirma::with('firmaRL', 'firmaEmpresarial', 'firmaJuridica', 'estado')->where('id', $id)->first();
    }
    public function delete($id)
    {
    }
    public function update($id, array $data)
    {
        $solicitud = SolicitudFirma::with('firmaRL', 'firmaEmpresarial', 'firmaJuridica', 'estado')->whereId($id)->first();
        if ($solicitud == null) {
            return null;
        } else {
            $solicitud->update($data);
            return $solicitud;
        }
    }
    public function create(array $data = [])
    {
        return SolicitudFirma::create($data + [
            'entidad_solicitante' => auth()->user()->entidad_id,
            'usuario_solicita' => auth()->user()->id,
            'firma_generada' => false,
            'fecha_solicitud' => Carbon::now()
        ]);
    }

    public function getSolicitutesNuevas($data)
    {
        return SolicitudFirma::with('firmaRL', 'firmaEmpresarial', 'firmaJuridica', 'estado')
            ->whereHas('estado', function ($q) {
                $q->where('estado', 'NUEVO');
            })
            ->orderBy('updated_at', 'desc')
            ->paginate($data->query('per_page') ?? 10);
    }
    public function getSolicitutesNuevasEntidad($data)
    {
        $entidad = EntidadComercial::with('usuario')->whereHas('usuario', function ($q) {
            $q->where('id', auth()->user()->id);
        })->first();
        return SolicitudFirma::with('firmaRL', 'firmaEmpresarial', 'firmaJuridica', 'estado')
            ->whereHas('estado', function ($q) {
                $q->where('estado', 'NUEVO');
            })
            ->where('entidad_solicitante', $entidad->id)
            ->paginate($data->query('per_page') ?? 10);
    }
    public function getSolicitutesQuince($data)
    {
        return SolicitudFirma::with('firmaRL', 'firmaEmpresarial', 'firmaJuridica', 'estado')
            ->whereHas('estado', function ($q) {
                $q->whereBetween('fecha_vencimiento', [Carbon::now()->addDays(0)->startOfDay(), Carbon::now()->addDays(15)->endOfDay()]);
            })
            ->paginate($data->query('per_page') ?? 10);
    }
    public function getSolicitutesSiete($data)
    {
        return SolicitudFirma::with('firmaRL', 'firmaEmpresarial', 'firmaJuridica', 'estado')
            ->whereHas('estado', function ($q) {
                $q->whereBetween('fecha_vencimiento', [Carbon::now()->addDays(0)->startOfDay(), Carbon::now()->addDays(7)->endOfDay()]);
            })
            ->paginate($data->query('per_page') ?? 10);
    }

    public function getCaducanQuinceAuth($data)
    {
        $entidad = EntidadComercial::with('usuario')->whereHas('usuario', function ($q) {
            $q->where('id', auth()->user()->id);
        })->first();
        return SolicitudFirma::with('firmaRL', 'firmaEmpresarial', 'firmaJuridica', 'estado')
            ->whereHas('estado', function ($q) {
                $q->whereBetween('fecha_vencimiento', [Carbon::now()->addDays(8)->startOfDay(), Carbon::now()->addDays(15)->endOfDay()]);
            })
            ->where('entidad_solicitante', $entidad->id)
            ->paginate($data->query('per_page') ?? 10);
    }

    public function getCaducanQuinceGeneraAuth($data)
    {
        return SolicitudFirma::with('firmaRL', 'firmaEmpresarial', 'firmaJuridica', 'estado')
            ->where('usuario_solicita', auth()->user()->id)->whereHas('estado', function ($q) {
                $q->whereBetween('fecha_vencimiento', [Carbon::now()->addDays(8)->startOfDay(), Carbon::now()->addDays(15)->endOfDay()]);
            })
            ->paginate($data->query('per_page') ?? 10);
    }

    public function getCaducanSieteAuth($data)
    {
        $entidad = EntidadComercial::with('usuario')->whereHas('usuario', function ($q) {
            $q->where('id', auth()->user()->id);
        })->first();
        return SolicitudFirma::with('firmaRL', 'firmaEmpresarial', 'firmaJuridica', 'estado')
            ->whereHas('estado', function ($q) {
                $q->whereBetween('fecha_vencimiento', [Carbon::now()->addDays(0)->startOfDay(), Carbon::now()->addDays(7)->endOfDay()]);
            })
            ->where('entidad_solicitante', $entidad->id)
            ->paginate($data->query('per_page') ?? 10);
    }

    public function getCaducanSieteGeneraAuth($data)
    {
        return SolicitudFirma::with('firmaRL', 'firmaEmpresarial', 'firmaJuridica', 'estado')
            ->where('usuario_solicita', auth()->user()->id)->whereHas('estado', function ($q) {
                $q->whereBetween('fecha_vencimiento', [Carbon::now()->addDays(0)->startOfDay(), Carbon::now()->addDays(7)->endOfDay()]);
            })
            ->paginate($data->query('per_page') ?? 10);
    }

    public function getFirmasIdentificacion($data, $numero_documento)
    {
        return SolicitudFirma::with('firmaRL', 'firmaEmpresarial', 'firmaJuridica', 'estado')
            ->where('numerodocumento', $numero_documento)
            ->paginate($data->query('per_page') ?? 10);
    }

    public function getFirmasIdentificacionEntidad($data, $numero_documento)
    {

        return SolicitudFirma::with('firmaRL', 'firmaEmpresarial', 'firmaJuridica', 'estado')
            ->where('numerodocumento', $numero_documento)
            ->where('entidad_solicitante', auth()->user()->entidad_id)
            ->paginate($data->query('per_page') ?? 10);
    }

    public function getFirmasIdentificacionUsuarioSolicita($data, $numero_documento)
    {
        return SolicitudFirma::with('firmaRL', 'firmaEmpresarial', 'firmaJuridica', 'estado')
            ->where('numerodocumento', $numero_documento)
            ->where('usuario_solicita', auth()->user()->id)
            ->paginate($data->query('per_page') ?? 10);
    }

    public function getSolicitudesEntidad($data)
    {
        return SolicitudFirma::with('firmaRL', 'firmaEmpresarial', 'firmaJuridica', 'estado')
            ->where('entidad_solicitante', auth()->user()->entidad_id)
            ->paginate($data->query('per_page') ?? 10);
    }

    public function getSolicitudesUsuarioSolicita($data)
    {
        return SolicitudFirma::with('firmaRL', 'firmaEmpresarial', 'firmaJuridica', 'estado')
            ->where('usuario_solicita', auth()->user()->id)
            ->paginate($data->query('per_page') ?? 10);
    }

    public function updateSolicitudEntidad($id, array $data)
    {
        $solicitud = SolicitudFirma::with('firmaRL', 'firmaEmpresarial', 'firmaJuridica', 'estado')->where('entidad_solicitante', auth()->user()->entidad_id)->whereId($id)->first();
        if ($solicitud == null) {
            return null;
        } else {
            return $solicitud->update($data);
        }
    }

    public function updateSolicitudUsuarioSolicita($id, array $data)
    {
        $solicitud = SolicitudFirma::with('firmaRL', 'firmaEmpresarial', 'firmaJuridica', 'estado')->where('usuario_solicita', auth()->user()->id)->whereId($id)->first();
        if ($solicitud == null) {
            return null;
        } else {
            return $solicitud->update($data);
        }
    }
}
