<?php

namespace App\Repositories;

use App\Interfaces\TipoFirmaRepositoryInterface;
use App\Models\TipoFirma;

class TipoFirmaRepository implements TipoFirmaRepositoryInterface
{
    public function getAllTiposFirmas()
    {
        return TipoFirma::orderBy('tiempo_validez', 'asc')->get();
    }

    public function getTipoFirmaById($tipofirmaId)
    {
        return TipoFirma::findOrFail($tipofirmaId);
    }

    public function deleteTipoFirma($tipofirmaId)
    {
        return TipoFirma::destroy($tipofirmaId);
    }

    public function createTipoFirma(array $tipofirmaDetails)
    {
        return TipoFirma::create($tipofirmaDetails);
    }

    public function updateTipoFirma($tipofirmaId, array $tipofirmaDetails)
    {
        TipoFirma::whereId($tipofirmaId)->update($tipofirmaDetails);
    }
}
