<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('tipos_usuarios', function (Blueprint $table) {
            $table->uuid('id')->primary();
            $table->enum('categoria',['ADMINISTRADOR','SOCIO']);
            $table->enum('subcategoria',['MASTER','SUPERVISOR','FINANCIERO','AUDITOR','EMISOR']);
            $table->string('identificador')->unique();

        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('tipos_usuarios');
    }
};
