<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('dispositivo', function (Blueprint $table) {
            $table->uuid('id')->primary();
            $table->foreignUuid('entidad_id')
                ->constrained('entidades_comerciales')
                ->cascadeOnUpdate()
                ->restrictOnDelete();
            $table->dateTime('ultima_conexion');
            $table->string('nombre_dispositivo');
            $table->string('ubicacion');
            $table->string('observaciones_diagnostico');
            $table->boolean('estado')->default(0);
            $table->boolean('estado_diagnostico')->default(0);
            $table->string('version_apk_instalada');
            $table->string('ip_publica');
            $table->string('codigo_remoto');
            $table->string('herramienta_remoto');
            $table->string('token_push_FCM');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('dispositivo');
    }
};
