<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('pagos', function (Blueprint $table) {
            $table->uuid('id')->primary();
            $table->foreignUuid('entidad_id')
                ->constrained('entidades_comerciales')
                ->cascadeOnUpdate()
                ->restrictOnDelete();
            $table->double('valor_pagado');
            $table->dateTime('fecha_pago');
            $table->foreignUuid('usuario_registra')
                ->constrained('usuarios')
                ->cascadeOnUpdate()
                ->restrictOnDelete();
            $table->string('tipo_pago');
            $table->string('comprobante_url');
            $table->string('descripcion');
            $table->boolean('validado');
            $table->foreignUuid('usuario_valida')
                ->constrained('usuarios')
                ->cascadeOnUpdate()
                ->restrictOnDelete();
            $table->foreignUuid('solicitud_previa_id')
                ->constrained('solicitudes_previas')
                ->cascadeOnUpdate()
                ->restrictOnDelete();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('pagos');
    }
};
