<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('firmas_juridicas', function (Blueprint $table) {
            $table->uuid('id')->primary();
            $table->foreignUuid('solicitud_id')
                ->constrained('solicitudes_firmas')
                ->cascadeOnUpdate()
                ->restrictOnDelete();
            $table->string('ruc_empresa');
            $table->string('empresa');
            $table->string('cargo');
            $table->string('motivo');
            $table->string('unidad');
            $table->string('f_autreprelegal')->nullable();
            $table->string('f_nombramiento')->nullable();
            $table->string('f_nombramiento2')->nullable();
            $table->string('f_constitucion')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('firmas_juridicas');
    }
};
