<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('solicitudes_lote', function (Blueprint $table) {
            $table->uuid('id')->primary();
            $table->foreignUuid('lote_id')
            ->constrained('registro_lotes')
            ->cascadeOnUpdate()
            ->restrictOnDelete();
            $table->foreignUuid('solicitud_id')
                ->constrained('solicitudes_firmas')
                ->cascadeOnUpdate()
                ->restrictOnDelete();
            $table->enum('estado',['NUEVO','PROCESADO','GENERADA','CANCELADA','ELIMINADA']);
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('solicitudes_lote');
    }
};
