<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('solicitudes_iniciales', function (Blueprint $table) {
            $table->uuid('id')->primary();
            $table->string('cedula');
            $table->string('email');
            $table->string('telefono');
            $table->foreignUuid('entidad_id')
                ->constrained('entidades_comerciales')
                ->cascadeOnUpdate()
                ->restrictOnDelete();
            $table->enum('estado',['NUEVO','PROCESADO','GENERADA','CANCELADA','ELIMINADA']);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('solicitudes_iniciales');
    }
};
