<?php
// Incluir el archivo de conexión
include("conexion.php");


$modificados = array();
$noModificados = array();
$listaEstadosConsultables = ["2", "3", "4", "5", "7", "12"];

$buscarEstadoPorNombre = '{
    "NUEVA SOLICITUD":"1",
    "SOLICITUD INGRESADA":"2",
    "ASIGNADO":"3",
    "EN VALIDACION":"4",
    "RECHAZADO":"5",
    "ELIMINADO":"6",
    "APROBADO":"7",
    "EMITIDO (VALIDO)":"8",
    "EMITIDO (SUSPENDIDO)":"9",
    "EMITIDO (REVOCADO)":"10",
    "EMITIDO (CADUCADO)":"11",
    "RECHAZADO y REENVIADO":"12",
    "REGISTERED":"2",
    "ERROR":"3",
    "VALIDATING":"4",
    "REFUSED":"5",
    "APPROVED":"7",
    "GENERATED":"8",
    "EXPIRED":"11"
}';

$estadosJSON = '{
    "1":{
     "estado": "NUEVA SOLICITUD"
    },
    "2":{
     "estado": "SOLICITUD INGRESADA"
    },
    "3":{
     "estado": "ASIGNADO"
    },
    "4":{
     "estado": "EN VALIDACION"
    },
    "5":{
     "estado": "RECHAZADO"
    },
    "6":{
     "estado": "ELIMINADO"
    },
    "7":{
     "estado": "APROBADO"
    },
    "8":{
     "estado": "EMITIDO (VALIDO)"
    },
    "9":{
     "estado": "EMITIDO (SUSPENDIDO)"
    },
    "10":{
     "estado": "EMITIDO (REVOCADO)"
    },
    "11":{
     "estado": "EMITIDO (CADUCADO)"
    },
    "12":{
     "estado": "RECHAZADO y REENVIADO"
    }
}';

// Construir la parte de la consulta SQL con los estados
$condicionEstados = '';
foreach ($listaEstadosConsultables as $estado) {
    $condicionEstados .= "estado = '$estado' OR ";
}

// Eliminar el último "OR" redundante
$condicionEstados = rtrim($condicionEstados, " OR ");

// Consulta SQL con la condición de estados y uanataca_id no NULL y no "undefined"
$sql = "SELECT id, estado, uanataca_id, identificacion, tipo_persona, created_at,observacion_uanataca FROM solicitudes_previas WHERE ($condicionEstados) AND uanataca_id IS NOT NULL AND uanataca_id <> 'undefined' ORDER BY created_at DESC";

//echo $sql;
// Ejecutar la consulta
$resultado = $conexion->query($sql);

if (!$resultado) {
    die("Error en la consulta: " . $conexion->error);
}

// Crear un array para almacenar los resultados
$solicitudes_previas = array();

// Obtener los resultados de la consulta
while ($fila = $resultado->fetch_assoc()) {



    $actualizado=false;

    $tipo_persona=$fila['tipo_persona'];

    if ($tipo_persona === 'PERSONA NATURAL CON RUC') {
        $tipo_persona = 'PERSONA NATURAL';
    }

//Aqui llamar a consulta de estados
if (str_starts_with($fila['uanataca_id'], 'FEP')) {
    $consulta_url = "http://apifirmas.firmaecplus.com/firmaEstados/search_one_to_one_firmasegura.php?numerodocumento=" . urlencode($fila['identificacion']) . "&tipo_solicitud=" . urlencode($tipo_persona). "&uanataca_solicitud=" . urlencode($fila['uanataca_id']);
} elseif (ctype_digit($fila['uanataca_id'])) {
    
echo  '<br>'."NUEVO id";
echo $fila['uanataca_id'];
    // Si es un número entero (solo dígitos)
    $consulta_url = "http://apifirmas.firmaecplus.com/firmaEstados/search_one_to_one_newbest.php?numerodocumento=" 
        . urlencode($fila['identificacion']) 
        . "&tipo_solicitud=" . urlencode($tipo_persona)
        . "&uanataca_solicitud=" . urlencode($fila['uanataca_id']);
        echo '<br>'.$consulta_url;
} else {
    
    $consulta_url = "http://apifirmas.firmaecplus.com/firmaEstados/search_one_to_one_uanataca.php?numerodocumento=" . urlencode($fila['identificacion']) . "&tipo_solicitud=" . urlencode($tipo_persona). "&uanataca_solicitud=" . urlencode($fila['uanataca_id']);
}


// Realizar la solicitud HTTP GET a la URL de consulta
$response = file_get_contents($consulta_url);


// Verificar si se obtuvo una respuesta
if ($response === false) {
    die("Error al realizar la consulta a la /API de consulta_estado.php.");
}


$jsonData = json_decode($response, true);


if ($jsonData !== null && isset($jsonData['encontradaCoincidencia']) && $jsonData['encontradaCoincidencia'] === true) {
    // Conexión a la base de datos (Asegúrate de tener la conexión previamente establecida)


    // Verificar la conexión
    if ($conexion->connect_error) {
        die("Error de conexión: " . $conexion->connect_error);
    }




// Ejemplo de cómo buscar un estado por su nombre
echo $fila['uanataca_id'];
$nombreEstadoBuscado = $jsonData['estado'];
$jsonbuscarEstadoPorNombre = json_decode($buscarEstadoPorNombre, true);
if (isset($jsonbuscarEstadoPorNombre[$nombreEstadoBuscado])) {
$claveEstadoEncontrado = $jsonbuscarEstadoPorNombre[$nombreEstadoBuscado];
}

    // Bind de los parámetros
    $observacion = $jsonData['observacion'];
    $id = $fila['id']; // Reemplaza con el ID correcto
$sql ="";
if ($claveEstadoEncontrado !== null) {
        echo '<br>'.$claveEstadoEncontrado.':::1$claveEstadoEncontrado:::'.$id.'<br>';
        echo $nombreEstadoBuscado;
        echo $claveEstadoEncontrado;
    if($fila['estado']!=$claveEstadoEncontrado||$fila['observacion_uanataca']!=$observacion){
        $sql = "UPDATE solicitudes_previas SET estado = '$claveEstadoEncontrado', observacion_uanataca = '$observacion' WHERE id = '$id'";
    }
} else {
    if($fila['estado']!=$claveEstadoEncontrado||$fila['observacion_uanataca']!=$observacion){
        echo '<br>'.'2$claveEstadoEncontrado'.'<br>';
        echo $claveEstadoEncontrado;
    $sql = "UPDATE solicitudes_previas SET observacion_uanataca = '$observacion' WHERE id = '$id'";
    }
}
//echo "\n\n\n".$sql;

    // SQL UPDATEdie("Error en la preparación de la consulta: " . $conexion->error);

    // Ejecutar la consulta
    if(strlen($sql)){
        if ($conexion->query($sql)) {
            //echo "Actualización exitosa.";
            $actualizado=true;
        } else {
            //echo "Error en la actualización: " . $stmt->error;
        }
    }

} else {
    //echo "No se ejecutó la actualización porque 'encontradaCoincidencia' no es true.";
}


if ($actualizado) {
    $modificados[] = $fila['id'];
} else {
    $noModificados[] = $fila['id'];
}

}

// Obtén el timestamp en segundos con decimales
$timestamp = microtime(true);

// Convierte el timestamp en milisegundos multiplicando por 1000
$timestamp_ms = $timestamp * 1000;

// Redondea el resultado si es necesario
$timestamp_ms = round($timestamp_ms);
$fecha_actual = date("Y-m-d H:i:s");


    // Convertir los arrays en cadenas separadas por comas
    $cadena_modificados = implode(', ', $modificados);
    $cadena_no_modificados = implode(', ', $noModificados);
$sql="INSERT INTO log_dispositivo (id, dispositivo_id, descripcion, fecha_log, tipo_log, created_at, updated_at) VALUES ('cron_job_".$timestamp_ms."', 'cron_job_estados', '{modficados:  [".$cadena_modificados."], no_modificados: [".$cadena_no_modificados."]}', '".$timestamp_ms."', 'res_cron_job', '".$fecha_actual."', '".$fecha_actual."');";
if ($conexion->query($sql)) {
    echo "Actualización exitosa.";
} else {
    echo "Error en la actualización: " . $stmt->error;
}
// Cerrar la conexión
$conexion->close();

// Devolver los resultados en formato JSON
//header('Content-Type: application/json');
//echo json_encode($solicitudes_previas);
//echo json_encode(count($solicitudes_previas));
?>
