<?php
include("conexion.php");

// ====================
// 1️⃣ Login para obtener token y id_empresa
// ====================
$login_url = 'https://newsignapidev.newbest.net/newsignapi/login';
$login_body = json_encode([
    "identificacion_usuario" => "0604176289",
    "username_usuario"       => "tfirmaec",
    "password_usuario"       => "123456"
]);


$ch = curl_init($login_url);
curl_setopt($ch, CURLOPT_POST, true);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_HTTPHEADER, ['Content-Type: application/json']);
curl_setopt($ch, CURLOPT_POSTFIELDS, $login_body);

$response = curl_exec($ch);
$http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
curl_close($ch);

// Verificar login
if ($response === false || $http_code !== 200) {
    die("Error al obtener token desde la API de login.");
}

$login_data = json_decode($response, true);
if (empty($login_data['success']) || !$login_data['success'] || empty($login_data['token'])) {
    die("Error en login: no se pudo obtener token válido.");
}

$token = $login_data['token'];
$idEmpresa = $login_data['data']['id_empresa'] ?? null;
if (!$idEmpresa) {
    $idEmpresa = $login_data['data']['empresas']['id_empresa'] ?? null;
}
if (!$idEmpresa) {
    die("Error al obtener token desde la API de login.");
}

// Datos para la consulta a la API de Uanataca
$api_url = 'https://newsignapidev.newbest.net/newsignapi/firmaclientes/solicitud/distrapi/'.$idEmpresa.'/';

   // Obtén el valor desde la URL
$newbest_solicitud = $_GET['uanataca_solicitud'];  

$options = array(
    'http' => array(
        'header' => "Content-type: application/json\r\n" .
                    "Authorization: Bearer $token\r\n",
        'method' => 'GET'
    ),
);

$context = stream_context_create($options);
$api_response = file_get_contents($api_url.$newbest_solicitud, false, $context);

// Verificar si se obtuvo una respuesta de la API
if ($api_response === false) {
    die("Error al realizar la solicitud a la API de Uanataca.");
}

$json_response = $api_response; // Tu respuesta JSON completa aquí
$uanataca_id = $newbest_solicitud; // El valor que deseas buscar

// Decodificar el JSON en un arreglo asociativo
$response_data = json_decode($json_response, true);

$encontradaCoincidencia = false; // Variable para rastrear si se encontró una coincidencia
$observacion = ''; // Variable para almacenar la observación
$estado= ''; // Variable para almacenar la observación

if (isset($response_data['status'])) {

            // Se encontró una coincidencia
            $encontradaCoincidencia = true;
            $observacion = "Status: ".$response_data['status']."";
            //$estado = $response_data['status'];
            if (isset($response_data['data']) && is_array($response_data['data']) && count($response_data['data']) > 0) {
                
            $buscarEstadoPorID = '{
            "0":"REGISTERED",
            "1":"REGISTERED",
            "2":"ERROR",
            "3":"VALIDATING",
            "4":"ERROR",
            "5":"APPROVED",
            "6":"GENERATED"
            }';
                $estadoid = $response_data['data'][0]['estado_firmaCliente'] ?? '';
                $jsonbuscarEstadoPorid = json_decode($buscarEstadoPorID, true);
                if (isset($jsonbuscarEstadoPorid[$estadoid])) {
                $estado = $jsonbuscarEstadoPorid[$estadoid];
                }else{
                    $estado="ERROR";
                }
            } else {
                die("Error al realizar la solicitud a la API de NewBest.");
            }
}

// Ahora, puedes imprimir el resultado
$resultado = array(
    'encontradaCoincidencia' => $encontradaCoincidencia,
    'observacion' => $observacion,
    'estado' => $estado,
);


// Devolver la respuesta de la API como JSON
header('Content-Type: application/json');
echo json_encode($resultado);
?>
